// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// The [VVAR (Vertical Metrics Variations)](https://docs.microsoft.com/en-us/typography/opentype/spec/vvar) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Vvar {
    /// Offset in bytes from the start of this table to the item variation store table.
    pub item_variation_store: OffsetMarker<ItemVariationStore, WIDTH_32>,
    /// Offset in bytes from the start of this table to the delta-set index mapping for advance heights (may be NULL).
    pub advance_height_mapping: NullableOffsetMarker<DeltaSetIndexMap, WIDTH_32>,
    /// Offset in bytes from the start of this table to the delta-set index mapping for top side bearings (may be NULL).
    pub tsb_mapping: NullableOffsetMarker<DeltaSetIndexMap, WIDTH_32>,
    /// Offset in bytes from the start of this table to the delta-set index mapping for bottom side bearings (may be NULL).
    pub bsb_mapping: NullableOffsetMarker<DeltaSetIndexMap, WIDTH_32>,
    /// Offset in bytes from the start of this table to the delta-set index mapping for Y coordinates of vertical origins (may be NULL).
    pub v_org_mapping: NullableOffsetMarker<DeltaSetIndexMap, WIDTH_32>,
}

impl Vvar {
    /// Construct a new `Vvar`
    pub fn new(
        item_variation_store: ItemVariationStore,
        advance_height_mapping: Option<DeltaSetIndexMap>,
        tsb_mapping: Option<DeltaSetIndexMap>,
        bsb_mapping: Option<DeltaSetIndexMap>,
        v_org_mapping: Option<DeltaSetIndexMap>,
    ) -> Self {
        Self {
            item_variation_store: item_variation_store.into(),
            advance_height_mapping: advance_height_mapping.into(),
            tsb_mapping: tsb_mapping.into(),
            bsb_mapping: bsb_mapping.into(),
            v_org_mapping: v_org_mapping.into(),
        }
    }
}

impl FontWrite for Vvar {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (MajorMinor::VERSION_1_0 as MajorMinor).write_into(writer);
        self.item_variation_store.write_into(writer);
        self.advance_height_mapping.write_into(writer);
        self.tsb_mapping.write_into(writer);
        self.bsb_mapping.write_into(writer);
        self.v_org_mapping.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::TopLevel(Vvar::TAG)
    }
}

impl Validate for Vvar {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Vvar", |ctx| {
            ctx.in_field("item_variation_store", |ctx| {
                self.item_variation_store.validate_impl(ctx);
            });
            ctx.in_field("advance_height_mapping", |ctx| {
                self.advance_height_mapping.validate_impl(ctx);
            });
            ctx.in_field("tsb_mapping", |ctx| {
                self.tsb_mapping.validate_impl(ctx);
            });
            ctx.in_field("bsb_mapping", |ctx| {
                self.bsb_mapping.validate_impl(ctx);
            });
            ctx.in_field("v_org_mapping", |ctx| {
                self.v_org_mapping.validate_impl(ctx);
            });
        })
    }
}

impl TopLevelTable for Vvar {
    const TAG: Tag = Tag::new(b"VVAR");
}

impl<'a> FromObjRef<read_fonts::tables::vvar::Vvar<'a>> for Vvar {
    fn from_obj_ref(obj: &read_fonts::tables::vvar::Vvar<'a>, _: FontData) -> Self {
        Vvar {
            item_variation_store: obj.item_variation_store().to_owned_table(),
            advance_height_mapping: obj.advance_height_mapping().to_owned_table(),
            tsb_mapping: obj.tsb_mapping().to_owned_table(),
            bsb_mapping: obj.bsb_mapping().to_owned_table(),
            v_org_mapping: obj.v_org_mapping().to_owned_table(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::vvar::Vvar<'a>> for Vvar {}

impl<'a> FontRead<'a> for Vvar {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::vvar::Vvar as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}
