// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// The [vmtx (Vertical Metrics)](https://docs.microsoft.com/en-us/typography/opentype/spec/vmtx) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Vmtx {
    /// Paired advance height and top side bearing values for each
    /// glyph. Records are indexed by glyph ID.
    pub v_metrics: Vec<LongMetric>,
    /// Top side bearings for glyph IDs greater than or equal to numberOfLongMetrics.
    pub top_side_bearings: Vec<i16>,
}

impl Vmtx {
    /// Construct a new `Vmtx`
    pub fn new(v_metrics: Vec<LongMetric>, top_side_bearings: Vec<i16>) -> Self {
        Self {
            v_metrics,
            top_side_bearings,
        }
    }
}

impl FontWrite for Vmtx {
    fn write_into(&self, writer: &mut TableWriter) {
        self.v_metrics.write_into(writer);
        self.top_side_bearings.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::TopLevel(Vmtx::TAG)
    }
}

impl Validate for Vmtx {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Vmtx", |ctx| {
            ctx.in_field("v_metrics", |ctx| {
                if self.v_metrics.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.v_metrics.validate_impl(ctx);
            });
        })
    }
}

impl TopLevelTable for Vmtx {
    const TAG: Tag = Tag::new(b"vmtx");
}

impl<'a> FromObjRef<read_fonts::tables::vmtx::Vmtx<'a>> for Vmtx {
    fn from_obj_ref(obj: &read_fonts::tables::vmtx::Vmtx<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Vmtx {
            v_metrics: obj.v_metrics().to_owned_obj(offset_data),
            top_side_bearings: obj.top_side_bearings().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::vmtx::Vmtx<'a>> for Vmtx {}
