// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

pub use read_fonts::tables::variations::EntryFormat;

/// [TupleVariationHeader](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#tuplevariationheader)
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct TupleVariationHeader {
    /// The size in bytes of the serialized data for this tuple
    /// variation table.
    pub variation_data_size: u16,
    /// A packed field. The high 4 bits are flags (see below). The low
    /// 12 bits are an index into a shared tuple records array.
    pub tuple_index: TupleIndex,
    /// Peak tuple record for this tuple variation table — optional,
    /// determined by flags in the tupleIndex value.  Note that this
    /// must always be included in the 'cvar' table.
    pub peak_tuple: Vec<F2Dot14>,
    /// Intermediate start tuple record for this tuple variation table
    /// — optional, determined by flags in the tupleIndex value.
    pub intermediate_start_tuple: Vec<F2Dot14>,
    /// Intermediate end tuple record for this tuple variation table
    /// — optional, determined by flags in the tupleIndex value.
    pub intermediate_end_tuple: Vec<F2Dot14>,
}

impl FontWrite for TupleVariationHeader {
    fn write_into(&self, writer: &mut TableWriter) {
        self.variation_data_size.write_into(writer);
        self.tuple_index.write_into(writer);
        self.peak_tuple.write_into(writer);
        self.intermediate_start_tuple.write_into(writer);
        self.intermediate_end_tuple.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("TupleVariationHeader")
    }
}

impl Validate for TupleVariationHeader {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::variations::TupleVariationHeader<'a>>
    for TupleVariationHeader
{
    fn from_obj_ref(
        obj: &read_fonts::tables::variations::TupleVariationHeader<'a>,
        _: FontData,
    ) -> Self {
        let offset_data = obj.offset_data();
        TupleVariationHeader {
            variation_data_size: obj.variation_data_size(),
            tuple_index: obj.tuple_index(),
            peak_tuple: obj.peak_tuple().to_owned_obj(offset_data),
            intermediate_start_tuple: obj.intermediate_start_tuple().to_owned_obj(offset_data),
            intermediate_end_tuple: obj.intermediate_end_tuple().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::variations::TupleVariationHeader<'a>>
    for TupleVariationHeader
{
}

/// A [Tuple Record](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#tuple-records)
///
/// The tuple variation store formats reference regions within the font’s
/// variation space using tuple records. A tuple record identifies a position
/// in terms of normalized coordinates, which use F2DOT14 values.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Tuple {
    /// Coordinate array specifying a position within the font’s variation space.
    ///
    /// The number of elements must match the axisCount specified in the
    /// 'fvar' table.
    pub values: Vec<F2Dot14>,
}

impl Tuple {
    /// Construct a new `Tuple`
    pub fn new(values: Vec<F2Dot14>) -> Self {
        Self { values }
    }
}

impl FontWrite for Tuple {
    fn write_into(&self, writer: &mut TableWriter) {
        self.values.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("Tuple")
    }
}

impl Validate for Tuple {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Tuple", |ctx| {
            ctx.in_field("values", |ctx| {
                if self.values.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
            });
        })
    }
}

impl FromObjRef<read_fonts::tables::variations::Tuple<'_>> for Tuple {
    fn from_obj_ref(obj: &read_fonts::tables::variations::Tuple, offset_data: FontData) -> Self {
        Tuple {
            values: obj.values().to_owned_obj(offset_data),
        }
    }
}

/// The [DeltaSetIndexMap](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#associating-target-items-to-variation-data) table format 0
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct DeltaSetIndexMapFormat0 {
    /// A packed field that describes the compressed representation of
    /// delta-set indices. See details below.
    pub entry_format: EntryFormat,
    /// The number of mapping entries.
    pub map_count: u16,
    /// The delta-set index mapping data. See details below.
    pub map_data: Vec<u8>,
}

impl DeltaSetIndexMapFormat0 {
    /// Construct a new `DeltaSetIndexMapFormat0`
    pub fn new(entry_format: EntryFormat, map_count: u16, map_data: Vec<u8>) -> Self {
        Self {
            entry_format,
            map_count,
            map_data,
        }
    }
}

impl FontWrite for DeltaSetIndexMapFormat0 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (0 as u8).write_into(writer);
        self.entry_format.write_into(writer);
        self.map_count.write_into(writer);
        self.map_data.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("DeltaSetIndexMapFormat0")
    }
}

impl Validate for DeltaSetIndexMapFormat0 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::variations::DeltaSetIndexMapFormat0<'a>>
    for DeltaSetIndexMapFormat0
{
    fn from_obj_ref(
        obj: &read_fonts::tables::variations::DeltaSetIndexMapFormat0<'a>,
        _: FontData,
    ) -> Self {
        let offset_data = obj.offset_data();
        DeltaSetIndexMapFormat0 {
            entry_format: obj.entry_format(),
            map_count: obj.map_count(),
            map_data: obj.map_data().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::variations::DeltaSetIndexMapFormat0<'a>>
    for DeltaSetIndexMapFormat0
{
}

impl<'a> FontRead<'a> for DeltaSetIndexMapFormat0 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::variations::DeltaSetIndexMapFormat0 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// The [DeltaSetIndexMap](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#associating-target-items-to-variation-data) table format 1
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct DeltaSetIndexMapFormat1 {
    /// A packed field that describes the compressed representation of
    /// delta-set indices. See details below.
    pub entry_format: EntryFormat,
    /// The number of mapping entries.
    pub map_count: u32,
    /// The delta-set index mapping data. See details below.
    pub map_data: Vec<u8>,
}

impl DeltaSetIndexMapFormat1 {
    /// Construct a new `DeltaSetIndexMapFormat1`
    pub fn new(entry_format: EntryFormat, map_count: u32, map_data: Vec<u8>) -> Self {
        Self {
            entry_format,
            map_count,
            map_data,
        }
    }
}

impl FontWrite for DeltaSetIndexMapFormat1 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u8).write_into(writer);
        self.entry_format.write_into(writer);
        self.map_count.write_into(writer);
        self.map_data.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("DeltaSetIndexMapFormat1")
    }
}

impl Validate for DeltaSetIndexMapFormat1 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::variations::DeltaSetIndexMapFormat1<'a>>
    for DeltaSetIndexMapFormat1
{
    fn from_obj_ref(
        obj: &read_fonts::tables::variations::DeltaSetIndexMapFormat1<'a>,
        _: FontData,
    ) -> Self {
        let offset_data = obj.offset_data();
        DeltaSetIndexMapFormat1 {
            entry_format: obj.entry_format(),
            map_count: obj.map_count(),
            map_data: obj.map_data().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::variations::DeltaSetIndexMapFormat1<'a>>
    for DeltaSetIndexMapFormat1
{
}

impl<'a> FontRead<'a> for DeltaSetIndexMapFormat1 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::variations::DeltaSetIndexMapFormat1 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// The [DeltaSetIndexMap](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#associating-target-items-to-variation-data) table
#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub enum DeltaSetIndexMap {
    Format0(DeltaSetIndexMapFormat0),
    Format1(DeltaSetIndexMapFormat1),
}

impl DeltaSetIndexMap {
    /// Construct a new `DeltaSetIndexMapFormat0` subtable
    pub fn format_0(entry_format: EntryFormat, map_count: u16, map_data: Vec<u8>) -> Self {
        Self::Format0(DeltaSetIndexMapFormat0::new(
            entry_format,
            map_count,
            map_data,
        ))
    }

    /// Construct a new `DeltaSetIndexMapFormat1` subtable
    pub fn format_1(entry_format: EntryFormat, map_count: u32, map_data: Vec<u8>) -> Self {
        Self::Format1(DeltaSetIndexMapFormat1::new(
            entry_format,
            map_count,
            map_data,
        ))
    }
}

impl Default for DeltaSetIndexMap {
    fn default() -> Self {
        Self::Format0(Default::default())
    }
}

impl FontWrite for DeltaSetIndexMap {
    fn write_into(&self, writer: &mut TableWriter) {
        match self {
            Self::Format0(item) => item.write_into(writer),
            Self::Format1(item) => item.write_into(writer),
        }
    }
    fn table_type(&self) -> TableType {
        match self {
            Self::Format0(item) => item.table_type(),
            Self::Format1(item) => item.table_type(),
        }
    }
}

impl Validate for DeltaSetIndexMap {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        match self {
            Self::Format0(item) => item.validate_impl(ctx),
            Self::Format1(item) => item.validate_impl(ctx),
        }
    }
}

impl FromObjRef<read_fonts::tables::variations::DeltaSetIndexMap<'_>> for DeltaSetIndexMap {
    fn from_obj_ref(obj: &read_fonts::tables::variations::DeltaSetIndexMap, _: FontData) -> Self {
        use read_fonts::tables::variations::DeltaSetIndexMap as ObjRefType;
        match obj {
            ObjRefType::Format0(item) => DeltaSetIndexMap::Format0(item.to_owned_table()),
            ObjRefType::Format1(item) => DeltaSetIndexMap::Format1(item.to_owned_table()),
        }
    }
}

impl FromTableRef<read_fonts::tables::variations::DeltaSetIndexMap<'_>> for DeltaSetIndexMap {}

impl<'a> FontRead<'a> for DeltaSetIndexMap {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::variations::DeltaSetIndexMap as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

impl From<DeltaSetIndexMapFormat0> for DeltaSetIndexMap {
    fn from(src: DeltaSetIndexMapFormat0) -> DeltaSetIndexMap {
        DeltaSetIndexMap::Format0(src)
    }
}

impl From<DeltaSetIndexMapFormat1> for DeltaSetIndexMap {
    fn from(src: DeltaSetIndexMapFormat1) -> DeltaSetIndexMap {
        DeltaSetIndexMap::Format1(src)
    }
}

impl FontWrite for EntryFormat {
    fn write_into(&self, writer: &mut TableWriter) {
        writer.write_slice(&self.bits().to_be_bytes())
    }
}

/// The [VariationRegionList](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#variation-regions) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct VariationRegionList {
    /// The number of variation axes for this font. This must be the
    /// same number as axisCount in the 'fvar' table.
    pub axis_count: u16,
    /// Array of variation regions.
    pub variation_regions: Vec<VariationRegion>,
}

impl VariationRegionList {
    /// Construct a new `VariationRegionList`
    pub fn new(axis_count: u16, variation_regions: Vec<VariationRegion>) -> Self {
        Self {
            axis_count,
            variation_regions,
        }
    }
}

impl FontWrite for VariationRegionList {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        self.axis_count.write_into(writer);
        (u16::try_from(array_len(&self.variation_regions)).unwrap()).write_into(writer);
        self.variation_regions.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("VariationRegionList")
    }
}

impl Validate for VariationRegionList {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("VariationRegionList", |ctx| {
            ctx.in_field("variation_regions", |ctx| {
                if self.variation_regions.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.variation_regions.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::variations::VariationRegionList<'a>>
    for VariationRegionList
{
    fn from_obj_ref(
        obj: &read_fonts::tables::variations::VariationRegionList<'a>,
        _: FontData,
    ) -> Self {
        let offset_data = obj.offset_data();
        VariationRegionList {
            axis_count: obj.axis_count(),
            variation_regions: obj
                .variation_regions()
                .iter()
                .filter_map(|x| x.map(|x| FromObjRef::from_obj_ref(&x, offset_data)).ok())
                .collect(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::variations::VariationRegionList<'a>>
    for VariationRegionList
{
}

impl<'a> FontRead<'a> for VariationRegionList {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::variations::VariationRegionList as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// The [VariationRegion](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#variation-regions) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct VariationRegion {
    /// Array of region axis coordinates records, in the order of axes
    /// given in the 'fvar' table.
    pub region_axes: Vec<RegionAxisCoordinates>,
}

impl VariationRegion {
    /// Construct a new `VariationRegion`
    pub fn new(region_axes: Vec<RegionAxisCoordinates>) -> Self {
        Self { region_axes }
    }
}

impl FontWrite for VariationRegion {
    fn write_into(&self, writer: &mut TableWriter) {
        self.region_axes.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("VariationRegion")
    }
}

impl Validate for VariationRegion {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("VariationRegion", |ctx| {
            ctx.in_field("region_axes", |ctx| {
                if self.region_axes.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.region_axes.validate_impl(ctx);
            });
        })
    }
}

impl FromObjRef<read_fonts::tables::variations::VariationRegion<'_>> for VariationRegion {
    fn from_obj_ref(
        obj: &read_fonts::tables::variations::VariationRegion,
        offset_data: FontData,
    ) -> Self {
        VariationRegion {
            region_axes: obj.region_axes().to_owned_obj(offset_data),
        }
    }
}

/// The [RegionAxisCoordinates](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#variation-regions) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct RegionAxisCoordinates {
    /// The region start coordinate value for the current axis.
    pub start_coord: F2Dot14,
    /// The region peak coordinate value for the current axis.
    pub peak_coord: F2Dot14,
    /// The region end coordinate value for the current axis.
    pub end_coord: F2Dot14,
}

impl RegionAxisCoordinates {
    /// Construct a new `RegionAxisCoordinates`
    pub fn new(start_coord: F2Dot14, peak_coord: F2Dot14, end_coord: F2Dot14) -> Self {
        Self {
            start_coord,
            peak_coord,
            end_coord,
        }
    }
}

impl FontWrite for RegionAxisCoordinates {
    fn write_into(&self, writer: &mut TableWriter) {
        self.start_coord.write_into(writer);
        self.peak_coord.write_into(writer);
        self.end_coord.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("RegionAxisCoordinates")
    }
}

impl Validate for RegionAxisCoordinates {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::variations::RegionAxisCoordinates> for RegionAxisCoordinates {
    fn from_obj_ref(
        obj: &read_fonts::tables::variations::RegionAxisCoordinates,
        _: FontData,
    ) -> Self {
        RegionAxisCoordinates {
            start_coord: obj.start_coord(),
            peak_coord: obj.peak_coord(),
            end_coord: obj.end_coord(),
        }
    }
}

/// The [ItemVariationStore](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#item-variation-store-header-and-item-variation-data-subtables) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ItemVariationStore {
    /// Offset in bytes from the start of the item variation store to
    /// the variation region list.
    pub variation_region_list: OffsetMarker<VariationRegionList, WIDTH_32>,
    /// Offsets in bytes from the start of the item variation store to
    /// each item variation data subtable.
    pub item_variation_data: Vec<NullableOffsetMarker<ItemVariationData, WIDTH_32>>,
}

impl ItemVariationStore {
    /// Construct a new `ItemVariationStore`
    pub fn new(
        variation_region_list: VariationRegionList,
        item_variation_data: Vec<Option<ItemVariationData>>,
    ) -> Self {
        Self {
            variation_region_list: variation_region_list.into(),
            item_variation_data: item_variation_data.into_iter().map(Into::into).collect(),
        }
    }
}

impl FontWrite for ItemVariationStore {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u16).write_into(writer);
        self.variation_region_list.write_into(writer);
        (u16::try_from(array_len(&self.item_variation_data)).unwrap()).write_into(writer);
        self.item_variation_data.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ItemVariationStore")
    }
}

impl Validate for ItemVariationStore {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("ItemVariationStore", |ctx| {
            ctx.in_field("variation_region_list", |ctx| {
                self.variation_region_list.validate_impl(ctx);
            });
            ctx.in_field("item_variation_data", |ctx| {
                if self.item_variation_data.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.item_variation_data.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::variations::ItemVariationStore<'a>> for ItemVariationStore {
    fn from_obj_ref(
        obj: &read_fonts::tables::variations::ItemVariationStore<'a>,
        _: FontData,
    ) -> Self {
        ItemVariationStore {
            variation_region_list: obj.variation_region_list().to_owned_table(),
            item_variation_data: obj.item_variation_data().to_owned_table(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::variations::ItemVariationStore<'a>>
    for ItemVariationStore
{
}

impl<'a> FontRead<'a> for ItemVariationStore {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::variations::ItemVariationStore as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// The [ItemVariationData](https://learn.microsoft.com/en-us/typography/opentype/spec/otvarcommonformats#item-variation-store-header-and-item-variation-data-subtables) subtable
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ItemVariationData {
    /// The number of delta sets for distinct items.
    pub item_count: u16,
    /// A packed field: the high bit is a flag—see details below.
    pub word_delta_count: u16,
    /// Array of indices into the variation region list for the regions
    /// referenced by this item variation data table.
    pub region_indexes: Vec<u16>,
    /// Delta-set rows.
    pub delta_sets: Vec<u8>,
}

impl ItemVariationData {
    /// Construct a new `ItemVariationData`
    pub fn new(
        item_count: u16,
        word_delta_count: u16,
        region_indexes: Vec<u16>,
        delta_sets: Vec<u8>,
    ) -> Self {
        Self {
            item_count,
            word_delta_count,
            region_indexes,
            delta_sets,
        }
    }
}

impl FontWrite for ItemVariationData {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        self.item_count.write_into(writer);
        self.word_delta_count.write_into(writer);
        (u16::try_from(array_len(&self.region_indexes)).unwrap()).write_into(writer);
        self.region_indexes.write_into(writer);
        self.delta_sets.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ItemVariationData")
    }
}

impl Validate for ItemVariationData {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("ItemVariationData", |ctx| {
            ctx.in_field("region_indexes", |ctx| {
                if self.region_indexes.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::variations::ItemVariationData<'a>> for ItemVariationData {
    fn from_obj_ref(
        obj: &read_fonts::tables::variations::ItemVariationData<'a>,
        _: FontData,
    ) -> Self {
        let offset_data = obj.offset_data();
        ItemVariationData {
            item_count: obj.item_count(),
            word_delta_count: obj.word_delta_count(),
            region_indexes: obj.region_indexes().to_owned_obj(offset_data),
            delta_sets: obj.delta_sets().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::variations::ItemVariationData<'a>> for ItemVariationData {}

impl<'a> FontRead<'a> for ItemVariationData {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::variations::ItemVariationData as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}
