// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct BasicTable {
    pub simple_records: Vec<SimpleRecord>,
    pub array_records: Vec<ContainsArrays>,
}

impl BasicTable {
    /// Construct a new `BasicTable`
    pub fn new(simple_records: Vec<SimpleRecord>, array_records: Vec<ContainsArrays>) -> Self {
        Self {
            simple_records,
            array_records,
        }
    }
}

impl FontWrite for BasicTable {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (u16::try_from(array_len(&self.simple_records)).unwrap()).write_into(writer);
        self.simple_records.write_into(writer);
        (self.compute_arrays_inner_count() as u16).write_into(writer);
        (u32::try_from(array_len(&self.array_records)).unwrap()).write_into(writer);
        self.array_records.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("BasicTable")
    }
}

impl Validate for BasicTable {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("BasicTable", |ctx| {
            ctx.in_field("simple_records", |ctx| {
                if self.simple_records.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.simple_records.validate_impl(ctx);
            });
            ctx.in_field("array_records", |ctx| {
                if self.array_records.len() > (u32::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.array_records.validate_impl(ctx);
            });
            self.my_custom_validate(ctx);
        })
    }
}

impl<'a> FromObjRef<read_fonts::codegen_test::records::BasicTable<'a>> for BasicTable {
    fn from_obj_ref(obj: &read_fonts::codegen_test::records::BasicTable<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        BasicTable {
            simple_records: obj.simple_records().to_owned_obj(offset_data),
            array_records: obj
                .array_records()
                .iter()
                .filter_map(|x| x.map(|x| FromObjRef::from_obj_ref(&x, offset_data)).ok())
                .collect(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::codegen_test::records::BasicTable<'a>> for BasicTable {}

impl<'a> FontRead<'a> for BasicTable {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::codegen_test::records::BasicTable as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct SimpleRecord {
    pub val1: u16,
    pub va2: u32,
}

impl SimpleRecord {
    /// Construct a new `SimpleRecord`
    pub fn new(val1: u16, va2: u32) -> Self {
        Self { val1, va2 }
    }
}

impl FontWrite for SimpleRecord {
    fn write_into(&self, writer: &mut TableWriter) {
        self.val1.write_into(writer);
        (self.compile_va2()).write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("SimpleRecord")
    }
}

impl Validate for SimpleRecord {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::codegen_test::records::SimpleRecord> for SimpleRecord {
    fn from_obj_ref(obj: &read_fonts::codegen_test::records::SimpleRecord, _: FontData) -> Self {
        SimpleRecord {
            val1: obj.val1(),
            va2: obj.va2(),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ContainsArrays {
    pub scalars: Vec<u16>,
    pub records: Vec<SimpleRecord>,
}

impl ContainsArrays {
    /// Construct a new `ContainsArrays`
    pub fn new(scalars: Vec<u16>, records: Vec<SimpleRecord>) -> Self {
        Self { scalars, records }
    }
}

impl FontWrite for ContainsArrays {
    fn write_into(&self, writer: &mut TableWriter) {
        self.scalars.write_into(writer);
        self.records.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ContainsArrays")
    }
}

impl Validate for ContainsArrays {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("ContainsArrays", |ctx| {
            ctx.in_field("scalars", |ctx| {
                if self.scalars.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
            });
            ctx.in_field("records", |ctx| {
                if self.records.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.records.validate_impl(ctx);
            });
        })
    }
}

impl FromObjRef<read_fonts::codegen_test::records::ContainsArrays<'_>> for ContainsArrays {
    fn from_obj_ref(
        obj: &read_fonts::codegen_test::records::ContainsArrays,
        offset_data: FontData,
    ) -> Self {
        ContainsArrays {
            scalars: obj.scalars().to_owned_obj(offset_data),
            records: obj.records().to_owned_obj(offset_data),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ContainsOffsets {
    pub array: OffsetMarker<Vec<SimpleRecord>>,
    pub other: OffsetMarker<BasicTable, WIDTH_32>,
}

impl ContainsOffsets {
    /// Construct a new `ContainsOffsets`
    pub fn new(array: Vec<SimpleRecord>, other: BasicTable) -> Self {
        Self {
            array: array.into(),
            other: other.into(),
        }
    }
}

impl FontWrite for ContainsOffsets {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (u16::try_from(array_len(&self.array)).unwrap()).write_into(writer);
        self.array.write_into(writer);
        self.other.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ContainsOffsets")
    }
}

impl Validate for ContainsOffsets {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("ContainsOffsets", |ctx| {
            ctx.in_field("array", |ctx| {
                self.array.validate_impl(ctx);
            });
            ctx.in_field("other", |ctx| {
                self.other.validate_impl(ctx);
            });
        })
    }
}

impl FromObjRef<read_fonts::codegen_test::records::ContainsOffsets> for ContainsOffsets {
    fn from_obj_ref(
        obj: &read_fonts::codegen_test::records::ContainsOffsets,
        offset_data: FontData,
    ) -> Self {
        ContainsOffsets {
            array: obj.array(offset_data).to_owned_obj(offset_data),
            other: obj.other(offset_data).to_owned_table(),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct VarLenItem {
    pub length: u32,
    pub data: Vec<u8>,
}

impl FontWrite for VarLenItem {
    fn write_into(&self, writer: &mut TableWriter) {
        self.length.write_into(writer);
        self.data.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("VarLenItem")
    }
}

impl Validate for VarLenItem {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::codegen_test::records::VarLenItem<'a>> for VarLenItem {
    fn from_obj_ref(obj: &read_fonts::codegen_test::records::VarLenItem<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        VarLenItem {
            length: obj.length(),
            data: obj.data().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::codegen_test::records::VarLenItem<'a>> for VarLenItem {}

impl<'a> FontRead<'a> for VarLenItem {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::codegen_test::records::VarLenItem as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}
