// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

pub use read_fonts::codegen_test::conditions::GotFlags;

#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct MajorMinorVersion {
    pub version: MajorMinor,
    pub always_present: u16,
    pub if_11: Option<u16>,
    pub if_20: Option<u32>,
}

impl Default for MajorMinorVersion {
    fn default() -> Self {
        Self {
            version: MajorMinor::VERSION_1_1,
            always_present: Default::default(),
            if_11: Default::default(),
            if_20: Default::default(),
        }
    }
}

impl FontWrite for MajorMinorVersion {
    fn write_into(&self, writer: &mut TableWriter) {
        let version = self.version;
        version.write_into(writer);
        self.always_present.write_into(writer);
        version.compatible((1u16, 1u16)).then(|| {
            self.if_11
                .as_ref()
                .expect("missing conditional field should have failed validation")
                .write_into(writer)
        });
        version.compatible((2u16, 0u16)).then(|| {
            self.if_20
                .as_ref()
                .expect("missing conditional field should have failed validation")
                .write_into(writer)
        });
    }
    fn table_type(&self) -> TableType {
        TableType::Named("MajorMinorVersion")
    }
}

impl Validate for MajorMinorVersion {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("MajorMinorVersion", |ctx| {
            let version = self.version;
            ctx.in_field("if_11", |ctx| {
                if version.compatible((1u16, 1u16)) && self.if_11.is_none() {
                    ctx.report(format!("field must be present for version {version}"));
                }
            });
            ctx.in_field("if_20", |ctx| {
                if version.compatible((2u16, 0u16)) && self.if_20.is_none() {
                    ctx.report(format!("field must be present for version {version}"));
                }
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::codegen_test::conditions::MajorMinorVersion<'a>>
    for MajorMinorVersion
{
    fn from_obj_ref(
        obj: &read_fonts::codegen_test::conditions::MajorMinorVersion<'a>,
        _: FontData,
    ) -> Self {
        MajorMinorVersion {
            version: obj.version(),
            always_present: obj.always_present(),
            if_11: obj.if_11(),
            if_20: obj.if_20(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::codegen_test::conditions::MajorMinorVersion<'a>>
    for MajorMinorVersion
{
}

impl<'a> FontRead<'a> for MajorMinorVersion {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::codegen_test::conditions::MajorMinorVersion as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

impl FontWrite for GotFlags {
    fn write_into(&self, writer: &mut TableWriter) {
        writer.write_slice(&self.bits().to_be_bytes())
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct FlagDay {
    pub volume: u16,
    pub flags: GotFlags,
    pub foo: Option<u16>,
    pub bar: Option<u16>,
    pub baz: Option<u16>,
}

impl FlagDay {
    /// Construct a new `FlagDay`
    pub fn new(volume: u16, flags: GotFlags) -> Self {
        Self {
            volume,
            flags,
            ..Default::default()
        }
    }
}

impl FontWrite for FlagDay {
    fn write_into(&self, writer: &mut TableWriter) {
        self.volume.write_into(writer);
        self.flags.write_into(writer);
        self.flags.contains(GotFlags::FOO).then(|| {
            self.foo
                .as_ref()
                .expect("missing conditional field should have failed validation")
                .write_into(writer)
        });
        self.flags.contains(GotFlags::BAR).then(|| {
            self.bar
                .as_ref()
                .expect("missing conditional field should have failed validation")
                .write_into(writer)
        });
        self.flags
            .intersects(GotFlags::BAZ | GotFlags::FOO)
            .then(|| {
                self.baz
                    .as_ref()
                    .expect("missing conditional field should have failed validation")
                    .write_into(writer)
            });
    }
    fn table_type(&self) -> TableType {
        TableType::Named("FlagDay")
    }
}

impl Validate for FlagDay {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("FlagDay", |ctx| {
            let flags = self.flags;
            ctx.in_field("foo", |ctx| {
                if !(flags.contains(GotFlags::FOO)) && self.foo.is_some() {
                    ctx.report("'foo' is present but FOO not set")
                }
                if (flags.contains(GotFlags::FOO)) && self.foo.is_none() {
                    ctx.report("FOO is set but 'foo' is None")
                }
            });
            ctx.in_field("bar", |ctx| {
                if !(flags.contains(GotFlags::BAR)) && self.bar.is_some() {
                    ctx.report("'bar' is present but BAR not set")
                }
                if (flags.contains(GotFlags::BAR)) && self.bar.is_none() {
                    ctx.report("BAR is set but 'bar' is None")
                }
            });
            ctx.in_field("baz", |ctx| {
                if !(flags.intersects(GotFlags::BAZ | GotFlags::FOO)) && self.baz.is_some() {
                    ctx.report("if_cond is not satisfied but 'baz' is present.");
                }
                if (flags.intersects(GotFlags::BAZ | GotFlags::FOO)) && self.baz.is_none() {
                    ctx.report("if_cond is satisfied by 'baz' is not present.");
                }
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::codegen_test::conditions::FlagDay<'a>> for FlagDay {
    fn from_obj_ref(obj: &read_fonts::codegen_test::conditions::FlagDay<'a>, _: FontData) -> Self {
        FlagDay {
            volume: obj.volume(),
            flags: obj.flags(),
            foo: obj.foo(),
            bar: obj.bar(),
            baz: obj.baz(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::codegen_test::conditions::FlagDay<'a>> for FlagDay {}

impl<'a> FontRead<'a> for FlagDay {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::codegen_test::conditions::FlagDay as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct FieldsAfterConditionals {
    pub flags: GotFlags,
    pub foo: Option<u16>,
    pub always_here: u16,
    pub bar: Option<u16>,
    pub baz: Option<u16>,
    pub also_always_here: u16,
    pub and_me_too: u16,
}

impl FieldsAfterConditionals {
    /// Construct a new `FieldsAfterConditionals`
    pub fn new(flags: GotFlags, always_here: u16, also_always_here: u16, and_me_too: u16) -> Self {
        Self {
            flags,
            always_here,
            also_always_here,
            and_me_too,
            ..Default::default()
        }
    }
}

impl FontWrite for FieldsAfterConditionals {
    fn write_into(&self, writer: &mut TableWriter) {
        self.flags.write_into(writer);
        self.flags.contains(GotFlags::FOO).then(|| {
            self.foo
                .as_ref()
                .expect("missing conditional field should have failed validation")
                .write_into(writer)
        });
        self.always_here.write_into(writer);
        self.flags.contains(GotFlags::BAR).then(|| {
            self.bar
                .as_ref()
                .expect("missing conditional field should have failed validation")
                .write_into(writer)
        });
        self.flags.contains(GotFlags::BAZ).then(|| {
            self.baz
                .as_ref()
                .expect("missing conditional field should have failed validation")
                .write_into(writer)
        });
        self.also_always_here.write_into(writer);
        self.and_me_too.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("FieldsAfterConditionals")
    }
}

impl Validate for FieldsAfterConditionals {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("FieldsAfterConditionals", |ctx| {
            let flags = self.flags;
            ctx.in_field("foo", |ctx| {
                if !(flags.contains(GotFlags::FOO)) && self.foo.is_some() {
                    ctx.report("'foo' is present but FOO not set")
                }
                if (flags.contains(GotFlags::FOO)) && self.foo.is_none() {
                    ctx.report("FOO is set but 'foo' is None")
                }
            });
            ctx.in_field("bar", |ctx| {
                if !(flags.contains(GotFlags::BAR)) && self.bar.is_some() {
                    ctx.report("'bar' is present but BAR not set")
                }
                if (flags.contains(GotFlags::BAR)) && self.bar.is_none() {
                    ctx.report("BAR is set but 'bar' is None")
                }
            });
            ctx.in_field("baz", |ctx| {
                if !(flags.contains(GotFlags::BAZ)) && self.baz.is_some() {
                    ctx.report("'baz' is present but BAZ not set")
                }
                if (flags.contains(GotFlags::BAZ)) && self.baz.is_none() {
                    ctx.report("BAZ is set but 'baz' is None")
                }
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::codegen_test::conditions::FieldsAfterConditionals<'a>>
    for FieldsAfterConditionals
{
    fn from_obj_ref(
        obj: &read_fonts::codegen_test::conditions::FieldsAfterConditionals<'a>,
        _: FontData,
    ) -> Self {
        FieldsAfterConditionals {
            flags: obj.flags(),
            foo: obj.foo(),
            always_here: obj.always_here(),
            bar: obj.bar(),
            baz: obj.baz(),
            also_always_here: obj.also_always_here(),
            and_me_too: obj.and_me_too(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::codegen_test::conditions::FieldsAfterConditionals<'a>>
    for FieldsAfterConditionals
{
}

impl<'a> FontRead<'a> for FieldsAfterConditionals {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::codegen_test::conditions::FieldsAfterConditionals as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}
