// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

pub use read_fonts::tables::sbix::HeaderFlags;

impl FontWrite for HeaderFlags {
    fn write_into(&self, writer: &mut TableWriter) {
        writer.write_slice(&self.bits().to_be_bytes())
    }
}

/// The [sbix (Standard Bitmap Graphics)](https://docs.microsoft.com/en-us/typography/opentype/spec/sbix) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Sbix {
    /// Bit 0: Set to 1.
    /// Bit 1: Draw outlines.
    /// Bits 2 to 15: reserved (set to 0).
    pub flags: HeaderFlags,
    /// Offsets from the beginning of the 'sbix' table to data for each individual bitmap strike.
    pub strikes: Vec<OffsetMarker<Strike, WIDTH_32>>,
}

impl Sbix {
    /// Construct a new `Sbix`
    pub fn new(flags: HeaderFlags, strikes: Vec<Strike>) -> Self {
        Self {
            flags,
            strikes: strikes.into_iter().map(Into::into).collect(),
        }
    }
}

impl FontWrite for Sbix {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u16).write_into(writer);
        (self.compile_header_flags()).write_into(writer);
        (u32::try_from(array_len(&self.strikes)).unwrap()).write_into(writer);
        self.strikes.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::TopLevel(Sbix::TAG)
    }
}

impl Validate for Sbix {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Sbix", |ctx| {
            ctx.in_field("strikes", |ctx| {
                if self.strikes.len() > (u32::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.strikes.validate_impl(ctx);
            });
        })
    }
}

impl TopLevelTable for Sbix {
    const TAG: Tag = Tag::new(b"sbix");
}

impl<'a> FromObjRef<read_fonts::tables::sbix::Sbix<'a>> for Sbix {
    fn from_obj_ref(obj: &read_fonts::tables::sbix::Sbix<'a>, _: FontData) -> Self {
        Sbix {
            flags: obj.flags(),
            strikes: obj.strikes().to_owned_table(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::sbix::Sbix<'a>> for Sbix {}

/// [Strike](https://learn.microsoft.com/en-us/typography/opentype/spec/sbix#strikes) header table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Strike {
    /// The PPEM size for which this strike was designed.
    pub ppem: u16,
    /// The device pixel density (in PPI) for which this strike was designed. (E.g., 96 PPI, 192 PPI.)
    pub ppi: u16,
    /// Offset from the beginning of the strike data header to bitmap data for an individual glyph ID.
    pub glyph_data_offsets: Vec<u32>,
}

impl Strike {
    /// Construct a new `Strike`
    pub fn new(ppem: u16, ppi: u16, glyph_data_offsets: Vec<u32>) -> Self {
        Self {
            ppem,
            ppi,
            glyph_data_offsets,
        }
    }
}

impl FontWrite for Strike {
    fn write_into(&self, writer: &mut TableWriter) {
        self.ppem.write_into(writer);
        self.ppi.write_into(writer);
        self.glyph_data_offsets.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("Strike")
    }
}

impl Validate for Strike {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::sbix::Strike<'a>> for Strike {
    fn from_obj_ref(obj: &read_fonts::tables::sbix::Strike<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Strike {
            ppem: obj.ppem(),
            ppi: obj.ppi(),
            glyph_data_offsets: obj.glyph_data_offsets().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::sbix::Strike<'a>> for Strike {}

/// [Glyph data](https://learn.microsoft.com/en-us/typography/opentype/spec/sbix#glyph-data) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct GlyphData {
    /// The horizontal (x-axis) position of the left edge of the bitmap graphic in relation to the glyph design space origin.
    pub origin_offset_x: i16,
    /// The vertical (y-axis) position of the bottom edge of the bitmap graphic in relation to the glyph design space origin.
    pub origin_offset_y: i16,
    /// Indicates the format of the embedded graphic data: one of 'jpg ', 'png ' or 'tiff', or the special format 'dupe'.
    pub graphic_type: Tag,
    /// The actual embedded graphic data. The total length is inferred from sequential entries in the glyphDataOffsets array and the fixed size (8 bytes) of the preceding fields.
    pub data: Vec<u8>,
}

impl GlyphData {
    /// Construct a new `GlyphData`
    pub fn new(
        origin_offset_x: i16,
        origin_offset_y: i16,
        graphic_type: Tag,
        data: Vec<u8>,
    ) -> Self {
        Self {
            origin_offset_x,
            origin_offset_y,
            graphic_type,
            data,
        }
    }
}

impl FontWrite for GlyphData {
    fn write_into(&self, writer: &mut TableWriter) {
        self.origin_offset_x.write_into(writer);
        self.origin_offset_y.write_into(writer);
        self.graphic_type.write_into(writer);
        self.data.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("GlyphData")
    }
}

impl Validate for GlyphData {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::sbix::GlyphData<'a>> for GlyphData {
    fn from_obj_ref(obj: &read_fonts::tables::sbix::GlyphData<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        GlyphData {
            origin_offset_x: obj.origin_offset_x(),
            origin_offset_y: obj.origin_offset_y(),
            graphic_type: obj.graphic_type(),
            data: obj.data().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::sbix::GlyphData<'a>> for GlyphData {}

impl<'a> FontRead<'a> for GlyphData {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::sbix::GlyphData as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}
