// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// An array of variable-sized objects in a `CFF` table.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Index1 {
    /// Number of objects stored in INDEX.
    pub count: u16,
    /// Object array element size.
    pub off_size: u8,
    /// Bytes containing `count + 1` offsets each of `off_size`.
    pub offsets: Vec<u8>,
    /// Array containing the object data.
    pub data: Vec<u8>,
}

impl Index1 {
    /// Construct a new `Index1`
    pub fn new(count: u16, off_size: u8, offsets: Vec<u8>, data: Vec<u8>) -> Self {
        Self {
            count,
            off_size,
            offsets,
            data,
        }
    }
}

impl FontWrite for Index1 {
    fn write_into(&self, writer: &mut TableWriter) {
        self.count.write_into(writer);
        self.off_size.write_into(writer);
        self.offsets.write_into(writer);
        self.data.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("Index1")
    }
}

impl Validate for Index1 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::postscript::Index1<'a>> for Index1 {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::Index1<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Index1 {
            count: obj.count(),
            off_size: obj.off_size(),
            offsets: obj.offsets().to_owned_obj(offset_data),
            data: obj.data().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::postscript::Index1<'a>> for Index1 {}

impl<'a> FontRead<'a> for Index1 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::Index1 as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// An array of variable-sized objects in a `CFF2` table.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Index2 {
    /// Number of objects stored in INDEX.
    pub count: u32,
    /// Object array element size.
    pub off_size: u8,
    /// Bytes containing `count + 1` offsets each of `off_size`.
    pub offsets: Vec<u8>,
    /// Array containing the object data.
    pub data: Vec<u8>,
}

impl Index2 {
    /// Construct a new `Index2`
    pub fn new(count: u32, off_size: u8, offsets: Vec<u8>, data: Vec<u8>) -> Self {
        Self {
            count,
            off_size,
            offsets,
            data,
        }
    }
}

impl FontWrite for Index2 {
    fn write_into(&self, writer: &mut TableWriter) {
        self.count.write_into(writer);
        self.off_size.write_into(writer);
        self.offsets.write_into(writer);
        self.data.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("Index2")
    }
}

impl Validate for Index2 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::postscript::Index2<'a>> for Index2 {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::Index2<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Index2 {
            count: obj.count(),
            off_size: obj.off_size(),
            offsets: obj.offsets().to_owned_obj(offset_data),
            data: obj.data().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::postscript::Index2<'a>> for Index2 {}

impl<'a> FontRead<'a> for Index2 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::Index2 as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// Associates a glyph identifier with a Font DICT.
#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub enum FdSelect {
    Format0(FdSelectFormat0),
    Format3(FdSelectFormat3),
    Format4(FdSelectFormat4),
}

impl FdSelect {
    /// Construct a new `FdSelectFormat0` subtable
    pub fn format_0(fds: Vec<u8>) -> Self {
        Self::Format0(FdSelectFormat0::new(fds))
    }

    /// Construct a new `FdSelectFormat3` subtable
    pub fn format_3(ranges: Vec<FdSelectRange3>, sentinel: u16) -> Self {
        Self::Format3(FdSelectFormat3::new(ranges, sentinel))
    }

    /// Construct a new `FdSelectFormat4` subtable
    pub fn format_4(ranges: Vec<FdSelectRange4>, sentinel: u32) -> Self {
        Self::Format4(FdSelectFormat4::new(ranges, sentinel))
    }
}

impl Default for FdSelect {
    fn default() -> Self {
        Self::Format0(Default::default())
    }
}

impl FontWrite for FdSelect {
    fn write_into(&self, writer: &mut TableWriter) {
        match self {
            Self::Format0(item) => item.write_into(writer),
            Self::Format3(item) => item.write_into(writer),
            Self::Format4(item) => item.write_into(writer),
        }
    }
    fn table_type(&self) -> TableType {
        match self {
            Self::Format0(item) => item.table_type(),
            Self::Format3(item) => item.table_type(),
            Self::Format4(item) => item.table_type(),
        }
    }
}

impl Validate for FdSelect {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        match self {
            Self::Format0(item) => item.validate_impl(ctx),
            Self::Format3(item) => item.validate_impl(ctx),
            Self::Format4(item) => item.validate_impl(ctx),
        }
    }
}

impl FromObjRef<read_fonts::tables::postscript::FdSelect<'_>> for FdSelect {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::FdSelect, _: FontData) -> Self {
        use read_fonts::tables::postscript::FdSelect as ObjRefType;
        match obj {
            ObjRefType::Format0(item) => FdSelect::Format0(item.to_owned_table()),
            ObjRefType::Format3(item) => FdSelect::Format3(item.to_owned_table()),
            ObjRefType::Format4(item) => FdSelect::Format4(item.to_owned_table()),
        }
    }
}

impl FromTableRef<read_fonts::tables::postscript::FdSelect<'_>> for FdSelect {}

impl<'a> FontRead<'a> for FdSelect {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::FdSelect as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

impl From<FdSelectFormat0> for FdSelect {
    fn from(src: FdSelectFormat0) -> FdSelect {
        FdSelect::Format0(src)
    }
}

impl From<FdSelectFormat3> for FdSelect {
    fn from(src: FdSelectFormat3) -> FdSelect {
        FdSelect::Format3(src)
    }
}

impl From<FdSelectFormat4> for FdSelect {
    fn from(src: FdSelectFormat4) -> FdSelect {
        FdSelect::Format4(src)
    }
}

/// FdSelect format 0.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct FdSelectFormat0 {
    /// FD selector array (one entry for each glyph).
    pub fds: Vec<u8>,
}

impl FdSelectFormat0 {
    /// Construct a new `FdSelectFormat0`
    pub fn new(fds: Vec<u8>) -> Self {
        Self { fds }
    }
}

impl FontWrite for FdSelectFormat0 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (0 as u8).write_into(writer);
        self.fds.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("FdSelectFormat0")
    }
}

impl Validate for FdSelectFormat0 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::postscript::FdSelectFormat0<'a>> for FdSelectFormat0 {
    fn from_obj_ref(
        obj: &read_fonts::tables::postscript::FdSelectFormat0<'a>,
        _: FontData,
    ) -> Self {
        let offset_data = obj.offset_data();
        FdSelectFormat0 {
            fds: obj.fds().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::postscript::FdSelectFormat0<'a>> for FdSelectFormat0 {}

impl<'a> FontRead<'a> for FdSelectFormat0 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::FdSelectFormat0 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// FdSelect format 3.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct FdSelectFormat3 {
    /// Range3 array.
    pub ranges: Vec<FdSelectRange3>,
    /// Sentinel GID. Set equal to the number of glyphs in the font.
    pub sentinel: u16,
}

impl FdSelectFormat3 {
    /// Construct a new `FdSelectFormat3`
    pub fn new(ranges: Vec<FdSelectRange3>, sentinel: u16) -> Self {
        Self { ranges, sentinel }
    }
}

impl FontWrite for FdSelectFormat3 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (3 as u8).write_into(writer);
        (u16::try_from(array_len(&self.ranges)).unwrap()).write_into(writer);
        self.ranges.write_into(writer);
        self.sentinel.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("FdSelectFormat3")
    }
}

impl Validate for FdSelectFormat3 {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("FdSelectFormat3", |ctx| {
            ctx.in_field("ranges", |ctx| {
                if self.ranges.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.ranges.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::postscript::FdSelectFormat3<'a>> for FdSelectFormat3 {
    fn from_obj_ref(
        obj: &read_fonts::tables::postscript::FdSelectFormat3<'a>,
        _: FontData,
    ) -> Self {
        let offset_data = obj.offset_data();
        FdSelectFormat3 {
            ranges: obj.ranges().to_owned_obj(offset_data),
            sentinel: obj.sentinel(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::postscript::FdSelectFormat3<'a>> for FdSelectFormat3 {}

impl<'a> FontRead<'a> for FdSelectFormat3 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::FdSelectFormat3 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// Range struct for FdSelect format 3.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct FdSelectRange3 {
    /// First glyph index in range.
    pub first: u16,
    /// FD index for all glyphs in range.
    pub fd: u8,
}

impl FdSelectRange3 {
    /// Construct a new `FdSelectRange3`
    pub fn new(first: u16, fd: u8) -> Self {
        Self { first, fd }
    }
}

impl FontWrite for FdSelectRange3 {
    fn write_into(&self, writer: &mut TableWriter) {
        self.first.write_into(writer);
        self.fd.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("FdSelectRange3")
    }
}

impl Validate for FdSelectRange3 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::postscript::FdSelectRange3> for FdSelectRange3 {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::FdSelectRange3, _: FontData) -> Self {
        FdSelectRange3 {
            first: obj.first(),
            fd: obj.fd(),
        }
    }
}

/// FdSelect format 4.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct FdSelectFormat4 {
    /// Range4 array.
    pub ranges: Vec<FdSelectRange4>,
    /// Sentinel GID. Set equal to the number of glyphs in the font.
    pub sentinel: u32,
}

impl FdSelectFormat4 {
    /// Construct a new `FdSelectFormat4`
    pub fn new(ranges: Vec<FdSelectRange4>, sentinel: u32) -> Self {
        Self { ranges, sentinel }
    }
}

impl FontWrite for FdSelectFormat4 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (4 as u8).write_into(writer);
        (u32::try_from(array_len(&self.ranges)).unwrap()).write_into(writer);
        self.ranges.write_into(writer);
        self.sentinel.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("FdSelectFormat4")
    }
}

impl Validate for FdSelectFormat4 {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("FdSelectFormat4", |ctx| {
            ctx.in_field("ranges", |ctx| {
                if self.ranges.len() > (u32::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.ranges.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::postscript::FdSelectFormat4<'a>> for FdSelectFormat4 {
    fn from_obj_ref(
        obj: &read_fonts::tables::postscript::FdSelectFormat4<'a>,
        _: FontData,
    ) -> Self {
        let offset_data = obj.offset_data();
        FdSelectFormat4 {
            ranges: obj.ranges().to_owned_obj(offset_data),
            sentinel: obj.sentinel(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::postscript::FdSelectFormat4<'a>> for FdSelectFormat4 {}

impl<'a> FontRead<'a> for FdSelectFormat4 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::FdSelectFormat4 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// Range struct for FdSelect format 4.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct FdSelectRange4 {
    /// First glyph index in range.
    pub first: u32,
    /// FD index for all glyphs in range.
    pub fd: u16,
}

impl FdSelectRange4 {
    /// Construct a new `FdSelectRange4`
    pub fn new(first: u32, fd: u16) -> Self {
        Self { first, fd }
    }
}

impl FontWrite for FdSelectRange4 {
    fn write_into(&self, writer: &mut TableWriter) {
        self.first.write_into(writer);
        self.fd.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("FdSelectRange4")
    }
}

impl Validate for FdSelectRange4 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::postscript::FdSelectRange4> for FdSelectRange4 {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::FdSelectRange4, _: FontData) -> Self {
        FdSelectRange4 {
            first: obj.first(),
            fd: obj.fd(),
        }
    }
}

/// Charset with custom glyph id to string id mappings.
#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub enum CustomCharset {
    Format0(CharsetFormat0),
    Format1(CharsetFormat1),
    Format2(CharsetFormat2),
}

impl CustomCharset {
    /// Construct a new `CharsetFormat0` subtable
    pub fn format_0(glyph: Vec<u16>) -> Self {
        Self::Format0(CharsetFormat0::new(glyph))
    }

    /// Construct a new `CharsetFormat1` subtable
    pub fn format_1(ranges: Vec<CharsetRange1>) -> Self {
        Self::Format1(CharsetFormat1::new(ranges))
    }

    /// Construct a new `CharsetFormat2` subtable
    pub fn format_2(ranges: Vec<CharsetRange2>) -> Self {
        Self::Format2(CharsetFormat2::new(ranges))
    }
}

impl Default for CustomCharset {
    fn default() -> Self {
        Self::Format0(Default::default())
    }
}

impl FontWrite for CustomCharset {
    fn write_into(&self, writer: &mut TableWriter) {
        match self {
            Self::Format0(item) => item.write_into(writer),
            Self::Format1(item) => item.write_into(writer),
            Self::Format2(item) => item.write_into(writer),
        }
    }
    fn table_type(&self) -> TableType {
        match self {
            Self::Format0(item) => item.table_type(),
            Self::Format1(item) => item.table_type(),
            Self::Format2(item) => item.table_type(),
        }
    }
}

impl Validate for CustomCharset {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        match self {
            Self::Format0(item) => item.validate_impl(ctx),
            Self::Format1(item) => item.validate_impl(ctx),
            Self::Format2(item) => item.validate_impl(ctx),
        }
    }
}

impl FromObjRef<read_fonts::tables::postscript::CustomCharset<'_>> for CustomCharset {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::CustomCharset, _: FontData) -> Self {
        use read_fonts::tables::postscript::CustomCharset as ObjRefType;
        match obj {
            ObjRefType::Format0(item) => CustomCharset::Format0(item.to_owned_table()),
            ObjRefType::Format1(item) => CustomCharset::Format1(item.to_owned_table()),
            ObjRefType::Format2(item) => CustomCharset::Format2(item.to_owned_table()),
        }
    }
}

impl FromTableRef<read_fonts::tables::postscript::CustomCharset<'_>> for CustomCharset {}

impl<'a> FontRead<'a> for CustomCharset {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::CustomCharset as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

impl From<CharsetFormat0> for CustomCharset {
    fn from(src: CharsetFormat0) -> CustomCharset {
        CustomCharset::Format0(src)
    }
}

impl From<CharsetFormat1> for CustomCharset {
    fn from(src: CharsetFormat1) -> CustomCharset {
        CustomCharset::Format1(src)
    }
}

impl From<CharsetFormat2> for CustomCharset {
    fn from(src: CharsetFormat2) -> CustomCharset {
        CustomCharset::Format2(src)
    }
}

/// Charset format 0.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct CharsetFormat0 {
    /// Glyph name array.
    pub glyph: Vec<u16>,
}

impl CharsetFormat0 {
    /// Construct a new `CharsetFormat0`
    pub fn new(glyph: Vec<u16>) -> Self {
        Self { glyph }
    }
}

impl FontWrite for CharsetFormat0 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (0 as u8).write_into(writer);
        self.glyph.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("CharsetFormat0")
    }
}

impl Validate for CharsetFormat0 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::postscript::CharsetFormat0<'a>> for CharsetFormat0 {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::CharsetFormat0<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        CharsetFormat0 {
            glyph: obj.glyph().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::postscript::CharsetFormat0<'a>> for CharsetFormat0 {}

impl<'a> FontRead<'a> for CharsetFormat0 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::CharsetFormat0 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// Charset format 1.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct CharsetFormat1 {
    /// Range1 array.
    pub ranges: Vec<CharsetRange1>,
}

impl CharsetFormat1 {
    /// Construct a new `CharsetFormat1`
    pub fn new(ranges: Vec<CharsetRange1>) -> Self {
        Self { ranges }
    }
}

impl FontWrite for CharsetFormat1 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u8).write_into(writer);
        self.ranges.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("CharsetFormat1")
    }
}

impl Validate for CharsetFormat1 {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("CharsetFormat1", |ctx| {
            ctx.in_field("ranges", |ctx| {
                self.ranges.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::postscript::CharsetFormat1<'a>> for CharsetFormat1 {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::CharsetFormat1<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        CharsetFormat1 {
            ranges: obj.ranges().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::postscript::CharsetFormat1<'a>> for CharsetFormat1 {}

impl<'a> FontRead<'a> for CharsetFormat1 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::CharsetFormat1 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// Range struct for Charset format 1.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct CharsetRange1 {
    /// First glyph in range.
    pub first: u16,
    /// Glyphs left in range (excluding first).
    pub n_left: u8,
}

impl CharsetRange1 {
    /// Construct a new `CharsetRange1`
    pub fn new(first: u16, n_left: u8) -> Self {
        Self { first, n_left }
    }
}

impl FontWrite for CharsetRange1 {
    fn write_into(&self, writer: &mut TableWriter) {
        self.first.write_into(writer);
        self.n_left.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("CharsetRange1")
    }
}

impl Validate for CharsetRange1 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::postscript::CharsetRange1> for CharsetRange1 {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::CharsetRange1, _: FontData) -> Self {
        CharsetRange1 {
            first: obj.first(),
            n_left: obj.n_left(),
        }
    }
}

/// Charset format 2.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct CharsetFormat2 {
    /// Range2 array.
    pub ranges: Vec<CharsetRange2>,
}

impl CharsetFormat2 {
    /// Construct a new `CharsetFormat2`
    pub fn new(ranges: Vec<CharsetRange2>) -> Self {
        Self { ranges }
    }
}

impl FontWrite for CharsetFormat2 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (2 as u8).write_into(writer);
        self.ranges.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("CharsetFormat2")
    }
}

impl Validate for CharsetFormat2 {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("CharsetFormat2", |ctx| {
            ctx.in_field("ranges", |ctx| {
                self.ranges.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::postscript::CharsetFormat2<'a>> for CharsetFormat2 {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::CharsetFormat2<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        CharsetFormat2 {
            ranges: obj.ranges().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::postscript::CharsetFormat2<'a>> for CharsetFormat2 {}

impl<'a> FontRead<'a> for CharsetFormat2 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::postscript::CharsetFormat2 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// Range struct for Charset format 2.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct CharsetRange2 {
    /// First glyph in range.
    pub first: u16,
    /// Glyphs left in range (excluding first).
    pub n_left: u16,
}

impl CharsetRange2 {
    /// Construct a new `CharsetRange2`
    pub fn new(first: u16, n_left: u16) -> Self {
        Self { first, n_left }
    }
}

impl FontWrite for CharsetRange2 {
    fn write_into(&self, writer: &mut TableWriter) {
        self.first.write_into(writer);
        self.n_left.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("CharsetRange2")
    }
}

impl Validate for CharsetRange2 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::postscript::CharsetRange2> for CharsetRange2 {
    fn from_obj_ref(obj: &read_fonts::tables::postscript::CharsetRange2, _: FontData) -> Self {
        CharsetRange2 {
            first: obj.first(),
            n_left: obj.n_left(),
        }
    }
}
