// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// [`meta`](https://docs.microsoft.com/en-us/typography/opentype/spec/meta)
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Meta {
    /// Array of data map records.
    pub data_maps: Vec<DataMapRecord>,
}

impl Meta {
    /// Construct a new `Meta`
    pub fn new(data_maps: Vec<DataMapRecord>) -> Self {
        Self { data_maps }
    }
}

impl FontWrite for Meta {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u32).write_into(writer);
        (0 as u32).write_into(writer);
        (0 as u32).write_into(writer);
        (u32::try_from(array_len(&self.data_maps)).unwrap()).write_into(writer);
        self.data_maps.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::TopLevel(Meta::TAG)
    }
}

impl Validate for Meta {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Meta", |ctx| {
            ctx.in_field("data_maps", |ctx| {
                if self.data_maps.len() > (u32::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.data_maps.validate_impl(ctx);
            });
        })
    }
}

impl TopLevelTable for Meta {
    const TAG: Tag = Tag::new(b"meta");
}

impl<'a> FromObjRef<read_fonts::tables::meta::Meta<'a>> for Meta {
    fn from_obj_ref(obj: &read_fonts::tables::meta::Meta<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Meta {
            data_maps: obj.data_maps().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::meta::Meta<'a>> for Meta {}

impl<'a> FontRead<'a> for Meta {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::meta::Meta as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

///  <https://learn.microsoft.com/en-us/typography/opentype/spec/meta#table-formats>
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct DataMapRecord {
    /// A tag indicating the type of metadata.
    pub tag: Tag,
    /// Offset in bytes from the beginning of the metadata table to the data for this tag.
    pub data: OffsetMarker<Metadata, WIDTH_32>,
}

impl DataMapRecord {
    /// Construct a new `DataMapRecord`
    pub fn new(tag: Tag, data: Metadata) -> Self {
        Self {
            tag,
            data: data.into(),
        }
    }
}

impl FontWrite for DataMapRecord {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        self.tag.write_into(writer);
        self.data.write_into(writer);
        (self.compute_data_len() as u32).write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("DataMapRecord")
    }
}

impl Validate for DataMapRecord {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("DataMapRecord", |ctx| {
            ctx.in_field("data", |ctx| {
                self.validate_data_type(ctx);
            });
        })
    }
}
