// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// The [Horizontal Device Metrics](https://learn.microsoft.com/en-us/typography/opentype/spec/hdmx) table.
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Hdmx {
    /// Table version number (set to 0).
    pub version: u16,
    /// Number of device records.
    pub num_records: u16,
    /// Size of device record, 32-bit aligned.
    pub size_device_record: u32,
    /// Array of device records.
    pub records: Vec<DeviceRecord>,
}

impl Hdmx {
    /// Construct a new `Hdmx`
    pub fn new(
        version: u16,
        num_records: u16,
        size_device_record: u32,
        records: Vec<DeviceRecord>,
    ) -> Self {
        Self {
            version,
            num_records,
            size_device_record,
            records,
        }
    }
}

impl FontWrite for Hdmx {
    fn write_into(&self, writer: &mut TableWriter) {
        self.version.write_into(writer);
        self.num_records.write_into(writer);
        self.size_device_record.write_into(writer);
        self.records.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::TopLevel(Hdmx::TAG)
    }
}

impl Validate for Hdmx {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Hdmx", |ctx| {
            ctx.in_field("records", |ctx| {
                if self.records.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.records.validate_impl(ctx);
            });
        })
    }
}

impl TopLevelTable for Hdmx {
    const TAG: Tag = Tag::new(b"hdmx");
}

impl<'a> FromObjRef<read_fonts::tables::hdmx::Hdmx<'a>> for Hdmx {
    fn from_obj_ref(obj: &read_fonts::tables::hdmx::Hdmx<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Hdmx {
            version: obj.version(),
            num_records: obj.num_records(),
            size_device_record: obj.size_device_record(),
            records: obj
                .records()
                .iter()
                .filter_map(|x| x.map(|x| FromObjRef::from_obj_ref(&x, offset_data)).ok())
                .collect(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::hdmx::Hdmx<'a>> for Hdmx {}
