// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

pub use read_fonts::tables::gasp::GaspRangeBehavior;

/// [gasp](https://learn.microsoft.com/en-us/typography/opentype/spec/gasp#gasp-table-formats)
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Gasp {
    /// Version number (set to 1)
    pub version: u16,
    /// Number of records to follow
    pub num_ranges: u16,
    /// Sorted by ppem
    pub gasp_ranges: Vec<GaspRange>,
}

impl Gasp {
    /// Construct a new `Gasp`
    pub fn new(version: u16, num_ranges: u16, gasp_ranges: Vec<GaspRange>) -> Self {
        Self {
            version,
            num_ranges,
            gasp_ranges,
        }
    }
}

impl FontWrite for Gasp {
    fn write_into(&self, writer: &mut TableWriter) {
        self.version.write_into(writer);
        self.num_ranges.write_into(writer);
        self.gasp_ranges.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::TopLevel(Gasp::TAG)
    }
}

impl Validate for Gasp {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Gasp", |ctx| {
            ctx.in_field("gasp_ranges", |ctx| {
                if self.gasp_ranges.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.gasp_ranges.validate_impl(ctx);
            });
        })
    }
}

impl TopLevelTable for Gasp {
    const TAG: Tag = Tag::new(b"gasp");
}

impl<'a> FromObjRef<read_fonts::tables::gasp::Gasp<'a>> for Gasp {
    fn from_obj_ref(obj: &read_fonts::tables::gasp::Gasp<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Gasp {
            version: obj.version(),
            num_ranges: obj.num_ranges(),
            gasp_ranges: obj.gasp_ranges().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::gasp::Gasp<'a>> for Gasp {}

impl<'a> FontRead<'a> for Gasp {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::gasp::Gasp as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct GaspRange {
    /// Upper limit of range, in PPEM
    pub range_max_ppem: u16,
    /// Flags describing desired rasterizer behavior.
    pub range_gasp_behavior: GaspRangeBehavior,
}

impl GaspRange {
    /// Construct a new `GaspRange`
    pub fn new(range_max_ppem: u16, range_gasp_behavior: GaspRangeBehavior) -> Self {
        Self {
            range_max_ppem,
            range_gasp_behavior,
        }
    }
}

impl FontWrite for GaspRange {
    fn write_into(&self, writer: &mut TableWriter) {
        self.range_max_ppem.write_into(writer);
        self.range_gasp_behavior.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("GaspRange")
    }
}

impl Validate for GaspRange {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::gasp::GaspRange> for GaspRange {
    fn from_obj_ref(obj: &read_fonts::tables::gasp::GaspRange, _: FontData) -> Self {
        GaspRange {
            range_max_ppem: obj.range_max_ppem(),
            range_gasp_behavior: obj.range_gasp_behavior(),
        }
    }
}

impl FontWrite for GaspRangeBehavior {
    fn write_into(&self, writer: &mut TableWriter) {
        writer.write_slice(&self.bits().to_be_bytes())
    }
}
