// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

pub use read_fonts::tables::dsig::PermissionFlags;

/// [DSIG (Digital Signature Table)](https://docs.microsoft.com/en-us/typography/opentype/spec/dsig#table-structure) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Dsig {
    /// Permission flags
    pub flags: PermissionFlags,
    /// Array of signature records
    pub signature_records: Vec<SignatureRecord>,
}

impl Dsig {
    /// Construct a new `Dsig`
    pub fn new(flags: PermissionFlags, signature_records: Vec<SignatureRecord>) -> Self {
        Self {
            flags,
            signature_records,
        }
    }
}

impl FontWrite for Dsig {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u32).write_into(writer);
        (u16::try_from(array_len(&self.signature_records)).unwrap()).write_into(writer);
        self.flags.write_into(writer);
        self.signature_records.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::TopLevel(Dsig::TAG)
    }
}

impl Validate for Dsig {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Dsig", |ctx| {
            ctx.in_field("signature_records", |ctx| {
                if self.signature_records.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.signature_records.validate_impl(ctx);
            });
        })
    }
}

impl TopLevelTable for Dsig {
    const TAG: Tag = Tag::new(b"DSIG");
}

impl<'a> FromObjRef<read_fonts::tables::dsig::Dsig<'a>> for Dsig {
    fn from_obj_ref(obj: &read_fonts::tables::dsig::Dsig<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Dsig {
            flags: obj.flags(),
            signature_records: obj.signature_records().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::dsig::Dsig<'a>> for Dsig {}

impl<'a> FontRead<'a> for Dsig {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::dsig::Dsig as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

impl FontWrite for PermissionFlags {
    fn write_into(&self, writer: &mut TableWriter) {
        writer.write_slice(&self.bits().to_be_bytes())
    }
}

/// [Signature Record](https://learn.microsoft.com/en-us/typography/opentype/spec/dsig#table-structure)
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct SignatureRecord {
    /// Offset to the signature block from the beginning of the table
    pub signature_block: OffsetMarker<SignatureBlockFormat1, WIDTH_32>,
}

impl SignatureRecord {
    /// Construct a new `SignatureRecord`
    pub fn new(signature_block: SignatureBlockFormat1) -> Self {
        Self {
            signature_block: signature_block.into(),
        }
    }
}

impl FontWrite for SignatureRecord {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u32).write_into(writer);
        (self.compute_signature_block_len() as u32).write_into(writer);
        self.signature_block.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("SignatureRecord")
    }
}

impl Validate for SignatureRecord {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("SignatureRecord", |ctx| {
            ctx.in_field("signature_block", |ctx| {
                self.signature_block.validate_impl(ctx);
            });
        })
    }
}

impl FromObjRef<read_fonts::tables::dsig::SignatureRecord> for SignatureRecord {
    fn from_obj_ref(
        obj: &read_fonts::tables::dsig::SignatureRecord,
        offset_data: FontData,
    ) -> Self {
        SignatureRecord {
            signature_block: obj.signature_block(offset_data).to_owned_table(),
        }
    }
}

/// [Signature Block Format 1](https://learn.microsoft.com/en-us/typography/opentype/spec/dsig#table-structure)
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct SignatureBlockFormat1 {
    /// PKCS#7 packet
    pub signature: Vec<u8>,
}

impl SignatureBlockFormat1 {
    /// Construct a new `SignatureBlockFormat1`
    pub fn new(signature: Vec<u8>) -> Self {
        Self { signature }
    }
}

impl FontWrite for SignatureBlockFormat1 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (0 as u16).write_into(writer);
        (0 as u16).write_into(writer);
        (u32::try_from(array_len(&self.signature)).unwrap()).write_into(writer);
        self.signature.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("SignatureBlockFormat1")
    }
}

impl Validate for SignatureBlockFormat1 {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("SignatureBlockFormat1", |ctx| {
            ctx.in_field("signature", |ctx| {
                if self.signature.len() > (u32::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::dsig::SignatureBlockFormat1<'a>> for SignatureBlockFormat1 {
    fn from_obj_ref(
        obj: &read_fonts::tables::dsig::SignatureBlockFormat1<'a>,
        _: FontData,
    ) -> Self {
        let offset_data = obj.offset_data();
        SignatureBlockFormat1 {
            signature: obj.signature().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::dsig::SignatureBlockFormat1<'a>>
    for SignatureBlockFormat1
{
}

impl<'a> FontRead<'a> for SignatureBlockFormat1 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::dsig::SignatureBlockFormat1 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}
