// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

pub use read_fonts::tables::colr::{CompositeMode, Extend};

/// [COLR (Color)](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#colr-header) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Colr {
    /// Number of BaseGlyph records; may be 0 in a version 1 table.
    pub num_base_glyph_records: u16,
    /// Offset to baseGlyphRecords array (may be NULL).
    pub base_glyph_records: NullableOffsetMarker<Vec<BaseGlyph>, WIDTH_32>,
    /// Offset to layerRecords array (may be NULL).
    pub layer_records: NullableOffsetMarker<Vec<Layer>, WIDTH_32>,
    /// Number of Layer records; may be 0 in a version 1 table.
    pub num_layer_records: u16,
    /// Offset to BaseGlyphList table.
    pub base_glyph_list: NullableOffsetMarker<BaseGlyphList, WIDTH_32>,
    /// Offset to LayerList table (may be NULL).
    pub layer_list: NullableOffsetMarker<LayerList, WIDTH_32>,
    /// Offset to ClipList table (may be NULL).
    pub clip_list: NullableOffsetMarker<ClipList, WIDTH_32>,
    /// Offset to DeltaSetIndexMap table (may be NULL).
    pub var_index_map: NullableOffsetMarker<DeltaSetIndexMap, WIDTH_32>,
    /// Offset to ItemVariationStore (may be NULL).
    pub item_variation_store: NullableOffsetMarker<ItemVariationStore, WIDTH_32>,
}

impl Colr {
    /// Construct a new `Colr`
    pub fn new(
        num_base_glyph_records: u16,
        base_glyph_records: Option<Vec<BaseGlyph>>,
        layer_records: Option<Vec<Layer>>,
        num_layer_records: u16,
    ) -> Self {
        Self {
            num_base_glyph_records,
            base_glyph_records: base_glyph_records.into(),
            layer_records: layer_records.into(),
            num_layer_records,
            ..Default::default()
        }
    }
}

impl FontWrite for Colr {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        let version = self.compute_version() as u16;
        version.write_into(writer);
        self.num_base_glyph_records.write_into(writer);
        self.base_glyph_records.write_into(writer);
        self.layer_records.write_into(writer);
        self.num_layer_records.write_into(writer);
        version
            .compatible(1u16)
            .then(|| self.base_glyph_list.write_into(writer));
        version
            .compatible(1u16)
            .then(|| self.layer_list.write_into(writer));
        version
            .compatible(1u16)
            .then(|| self.clip_list.write_into(writer));
        version
            .compatible(1u16)
            .then(|| self.var_index_map.write_into(writer));
        version
            .compatible(1u16)
            .then(|| self.item_variation_store.write_into(writer));
    }
    fn table_type(&self) -> TableType {
        TableType::TopLevel(Colr::TAG)
    }
}

impl Validate for Colr {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Colr", |ctx| {
            ctx.in_field("base_glyph_records", |ctx| {
                self.base_glyph_records.validate_impl(ctx);
            });
            ctx.in_field("layer_records", |ctx| {
                self.layer_records.validate_impl(ctx);
            });
            ctx.in_field("base_glyph_list", |ctx| {
                self.base_glyph_list.validate_impl(ctx);
            });
            ctx.in_field("layer_list", |ctx| {
                self.layer_list.validate_impl(ctx);
            });
            ctx.in_field("clip_list", |ctx| {
                self.clip_list.validate_impl(ctx);
            });
            ctx.in_field("var_index_map", |ctx| {
                self.var_index_map.validate_impl(ctx);
            });
            ctx.in_field("item_variation_store", |ctx| {
                self.item_variation_store.validate_impl(ctx);
            });
        })
    }
}

impl TopLevelTable for Colr {
    const TAG: Tag = Tag::new(b"COLR");
}

impl<'a> FromObjRef<read_fonts::tables::colr::Colr<'a>> for Colr {
    fn from_obj_ref(obj: &read_fonts::tables::colr::Colr<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Colr {
            num_base_glyph_records: obj.num_base_glyph_records(),
            base_glyph_records: obj.base_glyph_records().to_owned_obj(offset_data),
            layer_records: obj.layer_records().to_owned_obj(offset_data),
            num_layer_records: obj.num_layer_records(),
            base_glyph_list: obj.base_glyph_list().to_owned_table(),
            layer_list: obj.layer_list().to_owned_table(),
            clip_list: obj.clip_list().to_owned_table(),
            var_index_map: obj.var_index_map().to_owned_table(),
            item_variation_store: obj.item_variation_store().to_owned_table(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::Colr<'a>> for Colr {}

impl<'a> FontRead<'a> for Colr {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::Colr as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [BaseGlyph](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyph-and-layer-records) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct BaseGlyph {
    /// Glyph ID of the base glyph.
    pub glyph_id: GlyphId16,
    /// Index (base 0) into the layerRecords array.
    pub first_layer_index: u16,
    /// Number of color layers associated with this glyph.
    pub num_layers: u16,
}

impl BaseGlyph {
    /// Construct a new `BaseGlyph`
    pub fn new(glyph_id: GlyphId16, first_layer_index: u16, num_layers: u16) -> Self {
        Self {
            glyph_id,
            first_layer_index,
            num_layers,
        }
    }
}

impl FontWrite for BaseGlyph {
    fn write_into(&self, writer: &mut TableWriter) {
        self.glyph_id.write_into(writer);
        self.first_layer_index.write_into(writer);
        self.num_layers.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("BaseGlyph")
    }
}

impl Validate for BaseGlyph {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::colr::BaseGlyph> for BaseGlyph {
    fn from_obj_ref(obj: &read_fonts::tables::colr::BaseGlyph, _: FontData) -> Self {
        BaseGlyph {
            glyph_id: obj.glyph_id(),
            first_layer_index: obj.first_layer_index(),
            num_layers: obj.num_layers(),
        }
    }
}

/// [Layer](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyph-and-layer-records) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Layer {
    /// Glyph ID of the glyph used for a given layer.
    pub glyph_id: GlyphId16,
    /// Index (base 0) for a palette entry in the CPAL table.
    pub palette_index: u16,
}

impl Layer {
    /// Construct a new `Layer`
    pub fn new(glyph_id: GlyphId16, palette_index: u16) -> Self {
        Self {
            glyph_id,
            palette_index,
        }
    }
}

impl FontWrite for Layer {
    fn write_into(&self, writer: &mut TableWriter) {
        self.glyph_id.write_into(writer);
        self.palette_index.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("Layer")
    }
}

impl Validate for Layer {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::colr::Layer> for Layer {
    fn from_obj_ref(obj: &read_fonts::tables::colr::Layer, _: FontData) -> Self {
        Layer {
            glyph_id: obj.glyph_id(),
            palette_index: obj.palette_index(),
        }
    }
}

/// [BaseGlyphList](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyphlist-layerlist-and-cliplist) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct BaseGlyphList {
    pub num_base_glyph_paint_records: u32,
    pub base_glyph_paint_records: Vec<BaseGlyphPaint>,
}

impl BaseGlyphList {
    /// Construct a new `BaseGlyphList`
    pub fn new(
        num_base_glyph_paint_records: u32,
        base_glyph_paint_records: Vec<BaseGlyphPaint>,
    ) -> Self {
        Self {
            num_base_glyph_paint_records,
            base_glyph_paint_records,
        }
    }
}

impl FontWrite for BaseGlyphList {
    fn write_into(&self, writer: &mut TableWriter) {
        self.num_base_glyph_paint_records.write_into(writer);
        self.base_glyph_paint_records.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("BaseGlyphList")
    }
}

impl Validate for BaseGlyphList {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("BaseGlyphList", |ctx| {
            ctx.in_field("base_glyph_paint_records", |ctx| {
                if self.base_glyph_paint_records.len() > (u32::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.base_glyph_paint_records.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::BaseGlyphList<'a>> for BaseGlyphList {
    fn from_obj_ref(obj: &read_fonts::tables::colr::BaseGlyphList<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        BaseGlyphList {
            num_base_glyph_paint_records: obj.num_base_glyph_paint_records(),
            base_glyph_paint_records: obj.base_glyph_paint_records().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::BaseGlyphList<'a>> for BaseGlyphList {}

impl<'a> FontRead<'a> for BaseGlyphList {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::BaseGlyphList as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [BaseGlyphPaint](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyphlist-layerlist-and-cliplist) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct BaseGlyphPaint {
    /// Glyph ID of the base glyph.
    pub glyph_id: GlyphId16,
    /// Offset to a Paint table, from the beginning of the [`BaseGlyphList`] table.
    pub paint: OffsetMarker<Paint, WIDTH_32>,
}

impl BaseGlyphPaint {
    /// Construct a new `BaseGlyphPaint`
    pub fn new(glyph_id: GlyphId16, paint: Paint) -> Self {
        Self {
            glyph_id,
            paint: paint.into(),
        }
    }
}

impl FontWrite for BaseGlyphPaint {
    fn write_into(&self, writer: &mut TableWriter) {
        self.glyph_id.write_into(writer);
        self.paint.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("BaseGlyphPaint")
    }
}

impl Validate for BaseGlyphPaint {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("BaseGlyphPaint", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl FromObjRef<read_fonts::tables::colr::BaseGlyphPaint> for BaseGlyphPaint {
    fn from_obj_ref(obj: &read_fonts::tables::colr::BaseGlyphPaint, offset_data: FontData) -> Self {
        BaseGlyphPaint {
            glyph_id: obj.glyph_id(),
            paint: obj.paint(offset_data).to_owned_table(),
        }
    }
}

/// [LayerList](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyphlist-layerlist-and-cliplist) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct LayerList {
    pub num_layers: u32,
    /// Offsets to Paint tables.
    pub paints: Vec<OffsetMarker<Paint, WIDTH_32>>,
}

impl LayerList {
    /// Construct a new `LayerList`
    pub fn new(num_layers: u32, paints: Vec<Paint>) -> Self {
        Self {
            num_layers,
            paints: paints.into_iter().map(Into::into).collect(),
        }
    }
}

impl FontWrite for LayerList {
    fn write_into(&self, writer: &mut TableWriter) {
        self.num_layers.write_into(writer);
        self.paints.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("LayerList")
    }
}

impl Validate for LayerList {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("LayerList", |ctx| {
            ctx.in_field("paints", |ctx| {
                if self.paints.len() > (u32::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.paints.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::LayerList<'a>> for LayerList {
    fn from_obj_ref(obj: &read_fonts::tables::colr::LayerList<'a>, _: FontData) -> Self {
        LayerList {
            num_layers: obj.num_layers(),
            paints: obj.paints().to_owned_table(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::LayerList<'a>> for LayerList {}

impl<'a> FontRead<'a> for LayerList {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::LayerList as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [ClipList](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyphlist-layerlist-and-cliplist) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ClipList {
    /// Set to 1.
    pub format: u8,
    /// Number of Clip records.
    pub num_clips: u32,
    /// Clip records. Sorted by startGlyphID.
    pub clips: Vec<Clip>,
}

impl ClipList {
    /// Construct a new `ClipList`
    pub fn new(format: u8, num_clips: u32, clips: Vec<Clip>) -> Self {
        Self {
            format,
            num_clips,
            clips,
        }
    }
}

impl FontWrite for ClipList {
    fn write_into(&self, writer: &mut TableWriter) {
        self.format.write_into(writer);
        self.num_clips.write_into(writer);
        self.clips.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ClipList")
    }
}

impl Validate for ClipList {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("ClipList", |ctx| {
            ctx.in_field("clips", |ctx| {
                if self.clips.len() > (u32::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.clips.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::ClipList<'a>> for ClipList {
    fn from_obj_ref(obj: &read_fonts::tables::colr::ClipList<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        ClipList {
            format: obj.format(),
            num_clips: obj.num_clips(),
            clips: obj.clips().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::ClipList<'a>> for ClipList {}

impl<'a> FontRead<'a> for ClipList {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::ClipList as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [Clip](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyphlist-layerlist-and-cliplist) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Clip {
    /// First glyph ID in the range.
    pub start_glyph_id: GlyphId16,
    /// Last glyph ID in the range.
    pub end_glyph_id: GlyphId16,
    /// Offset to a ClipBox table, from the beginning of the [`ClipList`] table.
    pub clip_box: OffsetMarker<ClipBox, WIDTH_24>,
}

impl Clip {
    /// Construct a new `Clip`
    pub fn new(start_glyph_id: GlyphId16, end_glyph_id: GlyphId16, clip_box: ClipBox) -> Self {
        Self {
            start_glyph_id,
            end_glyph_id,
            clip_box: clip_box.into(),
        }
    }
}

impl FontWrite for Clip {
    fn write_into(&self, writer: &mut TableWriter) {
        self.start_glyph_id.write_into(writer);
        self.end_glyph_id.write_into(writer);
        self.clip_box.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("Clip")
    }
}

impl Validate for Clip {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Clip", |ctx| {
            ctx.in_field("clip_box", |ctx| {
                self.clip_box.validate_impl(ctx);
            });
        })
    }
}

impl FromObjRef<read_fonts::tables::colr::Clip> for Clip {
    fn from_obj_ref(obj: &read_fonts::tables::colr::Clip, offset_data: FontData) -> Self {
        Clip {
            start_glyph_id: obj.start_glyph_id(),
            end_glyph_id: obj.end_glyph_id(),
            clip_box: obj.clip_box(offset_data).to_owned_table(),
        }
    }
}

/// [ClipBox](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyphlist-layerlist-and-cliplist) table
#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub enum ClipBox {
    Format1(ClipBoxFormat1),
    Format2(ClipBoxFormat2),
}

impl ClipBox {
    /// Construct a new `ClipBoxFormat1` subtable
    pub fn format_1(x_min: FWord, y_min: FWord, x_max: FWord, y_max: FWord) -> Self {
        Self::Format1(ClipBoxFormat1::new(x_min, y_min, x_max, y_max))
    }

    /// Construct a new `ClipBoxFormat2` subtable
    pub fn format_2(
        x_min: FWord,
        y_min: FWord,
        x_max: FWord,
        y_max: FWord,
        var_index_base: u32,
    ) -> Self {
        Self::Format2(ClipBoxFormat2::new(
            x_min,
            y_min,
            x_max,
            y_max,
            var_index_base,
        ))
    }
}

impl Default for ClipBox {
    fn default() -> Self {
        Self::Format1(Default::default())
    }
}

impl FontWrite for ClipBox {
    fn write_into(&self, writer: &mut TableWriter) {
        match self {
            Self::Format1(item) => item.write_into(writer),
            Self::Format2(item) => item.write_into(writer),
        }
    }
    fn table_type(&self) -> TableType {
        match self {
            Self::Format1(item) => item.table_type(),
            Self::Format2(item) => item.table_type(),
        }
    }
}

impl Validate for ClipBox {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        match self {
            Self::Format1(item) => item.validate_impl(ctx),
            Self::Format2(item) => item.validate_impl(ctx),
        }
    }
}

impl FromObjRef<read_fonts::tables::colr::ClipBox<'_>> for ClipBox {
    fn from_obj_ref(obj: &read_fonts::tables::colr::ClipBox, _: FontData) -> Self {
        use read_fonts::tables::colr::ClipBox as ObjRefType;
        match obj {
            ObjRefType::Format1(item) => ClipBox::Format1(item.to_owned_table()),
            ObjRefType::Format2(item) => ClipBox::Format2(item.to_owned_table()),
        }
    }
}

impl FromTableRef<read_fonts::tables::colr::ClipBox<'_>> for ClipBox {}

impl<'a> FontRead<'a> for ClipBox {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::ClipBox as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

impl From<ClipBoxFormat1> for ClipBox {
    fn from(src: ClipBoxFormat1) -> ClipBox {
        ClipBox::Format1(src)
    }
}

impl From<ClipBoxFormat2> for ClipBox {
    fn from(src: ClipBoxFormat2) -> ClipBox {
        ClipBox::Format2(src)
    }
}

/// [ClipBoxFormat1](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyphlist-layerlist-and-cliplist) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ClipBoxFormat1 {
    /// Minimum x of clip box.
    pub x_min: FWord,
    /// Minimum y of clip box.
    pub y_min: FWord,
    /// Maximum x of clip box.
    pub x_max: FWord,
    /// Maximum y of clip box.
    pub y_max: FWord,
}

impl ClipBoxFormat1 {
    /// Construct a new `ClipBoxFormat1`
    pub fn new(x_min: FWord, y_min: FWord, x_max: FWord, y_max: FWord) -> Self {
        Self {
            x_min,
            y_min,
            x_max,
            y_max,
        }
    }
}

impl FontWrite for ClipBoxFormat1 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u8).write_into(writer);
        self.x_min.write_into(writer);
        self.y_min.write_into(writer);
        self.x_max.write_into(writer);
        self.y_max.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ClipBoxFormat1")
    }
}

impl Validate for ClipBoxFormat1 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::colr::ClipBoxFormat1<'a>> for ClipBoxFormat1 {
    fn from_obj_ref(obj: &read_fonts::tables::colr::ClipBoxFormat1<'a>, _: FontData) -> Self {
        ClipBoxFormat1 {
            x_min: obj.x_min(),
            y_min: obj.y_min(),
            x_max: obj.x_max(),
            y_max: obj.y_max(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::ClipBoxFormat1<'a>> for ClipBoxFormat1 {}

impl<'a> FontRead<'a> for ClipBoxFormat1 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::ClipBoxFormat1 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [ClipBoxFormat2](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#baseglyphlist-layerlist-and-cliplist) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ClipBoxFormat2 {
    /// Minimum x of clip box. For variation, use varIndexBase + 0.
    pub x_min: FWord,
    /// Minimum y of clip box. For variation, use varIndexBase + 1.
    pub y_min: FWord,
    /// Maximum x of clip box. For variation, use varIndexBase + 2.
    pub x_max: FWord,
    /// Maximum y of clip box. For variation, use varIndexBase + 3.
    pub y_max: FWord,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl ClipBoxFormat2 {
    /// Construct a new `ClipBoxFormat2`
    pub fn new(
        x_min: FWord,
        y_min: FWord,
        x_max: FWord,
        y_max: FWord,
        var_index_base: u32,
    ) -> Self {
        Self {
            x_min,
            y_min,
            x_max,
            y_max,
            var_index_base,
        }
    }
}

impl FontWrite for ClipBoxFormat2 {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (2 as u8).write_into(writer);
        self.x_min.write_into(writer);
        self.y_min.write_into(writer);
        self.x_max.write_into(writer);
        self.y_max.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ClipBoxFormat2")
    }
}

impl Validate for ClipBoxFormat2 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::colr::ClipBoxFormat2<'a>> for ClipBoxFormat2 {
    fn from_obj_ref(obj: &read_fonts::tables::colr::ClipBoxFormat2<'a>, _: FontData) -> Self {
        ClipBoxFormat2 {
            x_min: obj.x_min(),
            y_min: obj.y_min(),
            x_max: obj.x_max(),
            y_max: obj.y_max(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::ClipBoxFormat2<'a>> for ClipBoxFormat2 {}

impl<'a> FontRead<'a> for ClipBoxFormat2 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::ClipBoxFormat2 as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [ColorIndex](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#color-references-colorstop-and-colorline) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ColorIndex {
    /// Index for a CPAL palette entry.
    pub palette_index: u16,
    /// Alpha value.
    pub alpha: F2Dot14,
}

impl ColorIndex {
    /// Construct a new `ColorIndex`
    pub fn new(palette_index: u16, alpha: F2Dot14) -> Self {
        Self {
            palette_index,
            alpha,
        }
    }
}

impl FontWrite for ColorIndex {
    fn write_into(&self, writer: &mut TableWriter) {
        self.palette_index.write_into(writer);
        self.alpha.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ColorIndex")
    }
}

impl Validate for ColorIndex {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::colr::ColorIndex> for ColorIndex {
    fn from_obj_ref(obj: &read_fonts::tables::colr::ColorIndex, _: FontData) -> Self {
        ColorIndex {
            palette_index: obj.palette_index(),
            alpha: obj.alpha(),
        }
    }
}

/// [VarColorIndex](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#color-references-colorstop-and-colorline) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct VarColorIndex {
    /// Index for a CPAL palette entry.
    pub palette_index: u16,
    /// Alpha value. For variation, use varIndexBase + 0.
    pub alpha: F2Dot14,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl VarColorIndex {
    /// Construct a new `VarColorIndex`
    pub fn new(palette_index: u16, alpha: F2Dot14, var_index_base: u32) -> Self {
        Self {
            palette_index,
            alpha,
            var_index_base,
        }
    }
}

impl FontWrite for VarColorIndex {
    fn write_into(&self, writer: &mut TableWriter) {
        self.palette_index.write_into(writer);
        self.alpha.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("VarColorIndex")
    }
}

impl Validate for VarColorIndex {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::colr::VarColorIndex> for VarColorIndex {
    fn from_obj_ref(obj: &read_fonts::tables::colr::VarColorIndex, _: FontData) -> Self {
        VarColorIndex {
            palette_index: obj.palette_index(),
            alpha: obj.alpha(),
            var_index_base: obj.var_index_base(),
        }
    }
}

/// [ColorStop](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#color-references-colorstop-and-colorline) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ColorStop {
    /// Position on a color line.
    pub stop_offset: F2Dot14,
    /// Index for a CPAL palette entry.
    pub palette_index: u16,
    /// Alpha value.
    pub alpha: F2Dot14,
}

impl ColorStop {
    /// Construct a new `ColorStop`
    pub fn new(stop_offset: F2Dot14, palette_index: u16, alpha: F2Dot14) -> Self {
        Self {
            stop_offset,
            palette_index,
            alpha,
        }
    }
}

impl FontWrite for ColorStop {
    fn write_into(&self, writer: &mut TableWriter) {
        self.stop_offset.write_into(writer);
        self.palette_index.write_into(writer);
        self.alpha.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ColorStop")
    }
}

impl Validate for ColorStop {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::colr::ColorStop> for ColorStop {
    fn from_obj_ref(obj: &read_fonts::tables::colr::ColorStop, _: FontData) -> Self {
        ColorStop {
            stop_offset: obj.stop_offset(),
            palette_index: obj.palette_index(),
            alpha: obj.alpha(),
        }
    }
}

/// [VarColorStop](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#color-references-colorstop-and-colorline) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct VarColorStop {
    /// Position on a color line. For variation, use varIndexBase + 0.
    pub stop_offset: F2Dot14,
    /// Index for a CPAL palette entry.
    pub palette_index: u16,
    /// Alpha value. For variation, use varIndexBase + 1.
    pub alpha: F2Dot14,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl VarColorStop {
    /// Construct a new `VarColorStop`
    pub fn new(
        stop_offset: F2Dot14,
        palette_index: u16,
        alpha: F2Dot14,
        var_index_base: u32,
    ) -> Self {
        Self {
            stop_offset,
            palette_index,
            alpha,
            var_index_base,
        }
    }
}

impl FontWrite for VarColorStop {
    fn write_into(&self, writer: &mut TableWriter) {
        self.stop_offset.write_into(writer);
        self.palette_index.write_into(writer);
        self.alpha.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("VarColorStop")
    }
}

impl Validate for VarColorStop {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl FromObjRef<read_fonts::tables::colr::VarColorStop> for VarColorStop {
    fn from_obj_ref(obj: &read_fonts::tables::colr::VarColorStop, _: FontData) -> Self {
        VarColorStop {
            stop_offset: obj.stop_offset(),
            palette_index: obj.palette_index(),
            alpha: obj.alpha(),
            var_index_base: obj.var_index_base(),
        }
    }
}

/// [ColorLine](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#color-references-colorstop-and-colorline) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct ColorLine {
    /// An Extend enum value.
    pub extend: Extend,
    /// Number of ColorStop records.
    pub num_stops: u16,
    pub color_stops: Vec<ColorStop>,
}

impl ColorLine {
    /// Construct a new `ColorLine`
    pub fn new(extend: Extend, num_stops: u16, color_stops: Vec<ColorStop>) -> Self {
        Self {
            extend,
            num_stops,
            color_stops,
        }
    }
}

impl FontWrite for ColorLine {
    fn write_into(&self, writer: &mut TableWriter) {
        self.extend.write_into(writer);
        self.num_stops.write_into(writer);
        self.color_stops.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("ColorLine")
    }
}

impl Validate for ColorLine {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("ColorLine", |ctx| {
            ctx.in_field("color_stops", |ctx| {
                if self.color_stops.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.color_stops.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::ColorLine<'a>> for ColorLine {
    fn from_obj_ref(obj: &read_fonts::tables::colr::ColorLine<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        ColorLine {
            extend: obj.extend(),
            num_stops: obj.num_stops(),
            color_stops: obj.color_stops().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::ColorLine<'a>> for ColorLine {}

impl<'a> FontRead<'a> for ColorLine {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::ColorLine as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [VarColorLine](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#color-references-colorstop-and-colorline) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct VarColorLine {
    /// An Extend enum value.
    pub extend: Extend,
    /// Number of ColorStop records.
    pub num_stops: u16,
    /// Allows for variations.
    pub color_stops: Vec<VarColorStop>,
}

impl VarColorLine {
    /// Construct a new `VarColorLine`
    pub fn new(extend: Extend, num_stops: u16, color_stops: Vec<VarColorStop>) -> Self {
        Self {
            extend,
            num_stops,
            color_stops,
        }
    }
}

impl FontWrite for VarColorLine {
    fn write_into(&self, writer: &mut TableWriter) {
        self.extend.write_into(writer);
        self.num_stops.write_into(writer);
        self.color_stops.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("VarColorLine")
    }
}

impl Validate for VarColorLine {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("VarColorLine", |ctx| {
            ctx.in_field("color_stops", |ctx| {
                if self.color_stops.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
                self.color_stops.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::VarColorLine<'a>> for VarColorLine {
    fn from_obj_ref(obj: &read_fonts::tables::colr::VarColorLine<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        VarColorLine {
            extend: obj.extend(),
            num_stops: obj.num_stops(),
            color_stops: obj.color_stops().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::VarColorLine<'a>> for VarColorLine {}

impl<'a> FontRead<'a> for VarColorLine {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::VarColorLine as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

impl FontWrite for Extend {
    fn write_into(&self, writer: &mut TableWriter) {
        let val = *self as u8;
        writer.write_slice(&val.to_be_bytes())
    }
}

/// [Paint](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#paint-tables) tables
#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub enum Paint {
    ColrLayers(PaintColrLayers),
    Solid(PaintSolid),
    VarSolid(PaintVarSolid),
    LinearGradient(PaintLinearGradient),
    VarLinearGradient(PaintVarLinearGradient),
    RadialGradient(PaintRadialGradient),
    VarRadialGradient(PaintVarRadialGradient),
    SweepGradient(PaintSweepGradient),
    VarSweepGradient(PaintVarSweepGradient),
    Glyph(PaintGlyph),
    ColrGlyph(PaintColrGlyph),
    Transform(PaintTransform),
    VarTransform(PaintVarTransform),
    Translate(PaintTranslate),
    VarTranslate(PaintVarTranslate),
    Scale(PaintScale),
    VarScale(PaintVarScale),
    ScaleAroundCenter(PaintScaleAroundCenter),
    VarScaleAroundCenter(PaintVarScaleAroundCenter),
    ScaleUniform(PaintScaleUniform),
    VarScaleUniform(PaintVarScaleUniform),
    ScaleUniformAroundCenter(PaintScaleUniformAroundCenter),
    VarScaleUniformAroundCenter(PaintVarScaleUniformAroundCenter),
    Rotate(PaintRotate),
    VarRotate(PaintVarRotate),
    RotateAroundCenter(PaintRotateAroundCenter),
    VarRotateAroundCenter(PaintVarRotateAroundCenter),
    Skew(PaintSkew),
    VarSkew(PaintVarSkew),
    SkewAroundCenter(PaintSkewAroundCenter),
    VarSkewAroundCenter(PaintVarSkewAroundCenter),
    Composite(PaintComposite),
}

impl Paint {
    /// Construct a new `PaintColrLayers` subtable
    pub fn colr_layers(num_layers: u8, first_layer_index: u32) -> Self {
        Self::ColrLayers(PaintColrLayers::new(num_layers, first_layer_index))
    }

    /// Construct a new `PaintSolid` subtable
    pub fn solid(palette_index: u16, alpha: F2Dot14) -> Self {
        Self::Solid(PaintSolid::new(palette_index, alpha))
    }

    /// Construct a new `PaintVarSolid` subtable
    pub fn var_solid(palette_index: u16, alpha: F2Dot14, var_index_base: u32) -> Self {
        Self::VarSolid(PaintVarSolid::new(palette_index, alpha, var_index_base))
    }

    /// Construct a new `PaintLinearGradient` subtable
    pub fn linear_gradient(
        color_line: ColorLine,
        x0: FWord,
        y0: FWord,
        x1: FWord,
        y1: FWord,
        x2: FWord,
        y2: FWord,
    ) -> Self {
        Self::LinearGradient(PaintLinearGradient::new(color_line, x0, y0, x1, y1, x2, y2))
    }

    /// Construct a new `PaintVarLinearGradient` subtable
    #[allow(clippy::too_many_arguments)]
    pub fn var_linear_gradient(
        color_line: VarColorLine,
        x0: FWord,
        y0: FWord,
        x1: FWord,
        y1: FWord,
        x2: FWord,
        y2: FWord,
        var_index_base: u32,
    ) -> Self {
        Self::VarLinearGradient(PaintVarLinearGradient::new(
            color_line,
            x0,
            y0,
            x1,
            y1,
            x2,
            y2,
            var_index_base,
        ))
    }

    /// Construct a new `PaintRadialGradient` subtable
    pub fn radial_gradient(
        color_line: ColorLine,
        x0: FWord,
        y0: FWord,
        radius0: UfWord,
        x1: FWord,
        y1: FWord,
        radius1: UfWord,
    ) -> Self {
        Self::RadialGradient(PaintRadialGradient::new(
            color_line, x0, y0, radius0, x1, y1, radius1,
        ))
    }

    /// Construct a new `PaintVarRadialGradient` subtable
    #[allow(clippy::too_many_arguments)]
    pub fn var_radial_gradient(
        color_line: VarColorLine,
        x0: FWord,
        y0: FWord,
        radius0: UfWord,
        x1: FWord,
        y1: FWord,
        radius1: UfWord,
        var_index_base: u32,
    ) -> Self {
        Self::VarRadialGradient(PaintVarRadialGradient::new(
            color_line,
            x0,
            y0,
            radius0,
            x1,
            y1,
            radius1,
            var_index_base,
        ))
    }

    /// Construct a new `PaintSweepGradient` subtable
    pub fn sweep_gradient(
        color_line: ColorLine,
        center_x: FWord,
        center_y: FWord,
        start_angle: F2Dot14,
        end_angle: F2Dot14,
    ) -> Self {
        Self::SweepGradient(PaintSweepGradient::new(
            color_line,
            center_x,
            center_y,
            start_angle,
            end_angle,
        ))
    }

    /// Construct a new `PaintVarSweepGradient` subtable
    pub fn var_sweep_gradient(
        color_line: VarColorLine,
        center_x: FWord,
        center_y: FWord,
        start_angle: F2Dot14,
        end_angle: F2Dot14,
        var_index_base: u32,
    ) -> Self {
        Self::VarSweepGradient(PaintVarSweepGradient::new(
            color_line,
            center_x,
            center_y,
            start_angle,
            end_angle,
            var_index_base,
        ))
    }

    /// Construct a new `PaintGlyph` subtable
    pub fn glyph(paint: Paint, glyph_id: GlyphId16) -> Self {
        Self::Glyph(PaintGlyph::new(paint, glyph_id))
    }

    /// Construct a new `PaintColrGlyph` subtable
    pub fn colr_glyph(glyph_id: GlyphId16) -> Self {
        Self::ColrGlyph(PaintColrGlyph::new(glyph_id))
    }

    /// Construct a new `PaintTransform` subtable
    pub fn transform(paint: Paint, transform: Affine2x3) -> Self {
        Self::Transform(PaintTransform::new(paint, transform))
    }

    /// Construct a new `PaintVarTransform` subtable
    pub fn var_transform(paint: Paint, transform: VarAffine2x3) -> Self {
        Self::VarTransform(PaintVarTransform::new(paint, transform))
    }

    /// Construct a new `PaintTranslate` subtable
    pub fn translate(paint: Paint, dx: FWord, dy: FWord) -> Self {
        Self::Translate(PaintTranslate::new(paint, dx, dy))
    }

    /// Construct a new `PaintVarTranslate` subtable
    pub fn var_translate(paint: Paint, dx: FWord, dy: FWord, var_index_base: u32) -> Self {
        Self::VarTranslate(PaintVarTranslate::new(paint, dx, dy, var_index_base))
    }

    /// Construct a new `PaintScale` subtable
    pub fn scale(paint: Paint, scale_x: F2Dot14, scale_y: F2Dot14) -> Self {
        Self::Scale(PaintScale::new(paint, scale_x, scale_y))
    }

    /// Construct a new `PaintVarScale` subtable
    pub fn var_scale(
        paint: Paint,
        scale_x: F2Dot14,
        scale_y: F2Dot14,
        var_index_base: u32,
    ) -> Self {
        Self::VarScale(PaintVarScale::new(paint, scale_x, scale_y, var_index_base))
    }

    /// Construct a new `PaintScaleAroundCenter` subtable
    pub fn scale_around_center(
        paint: Paint,
        scale_x: F2Dot14,
        scale_y: F2Dot14,
        center_x: FWord,
        center_y: FWord,
    ) -> Self {
        Self::ScaleAroundCenter(PaintScaleAroundCenter::new(
            paint, scale_x, scale_y, center_x, center_y,
        ))
    }

    /// Construct a new `PaintVarScaleAroundCenter` subtable
    pub fn var_scale_around_center(
        paint: Paint,
        scale_x: F2Dot14,
        scale_y: F2Dot14,
        center_x: FWord,
        center_y: FWord,
        var_index_base: u32,
    ) -> Self {
        Self::VarScaleAroundCenter(PaintVarScaleAroundCenter::new(
            paint,
            scale_x,
            scale_y,
            center_x,
            center_y,
            var_index_base,
        ))
    }

    /// Construct a new `PaintScaleUniform` subtable
    pub fn scale_uniform(paint: Paint, scale: F2Dot14) -> Self {
        Self::ScaleUniform(PaintScaleUniform::new(paint, scale))
    }

    /// Construct a new `PaintVarScaleUniform` subtable
    pub fn var_scale_uniform(paint: Paint, scale: F2Dot14, var_index_base: u32) -> Self {
        Self::VarScaleUniform(PaintVarScaleUniform::new(paint, scale, var_index_base))
    }

    /// Construct a new `PaintScaleUniformAroundCenter` subtable
    pub fn scale_uniform_around_center(
        paint: Paint,
        scale: F2Dot14,
        center_x: FWord,
        center_y: FWord,
    ) -> Self {
        Self::ScaleUniformAroundCenter(PaintScaleUniformAroundCenter::new(
            paint, scale, center_x, center_y,
        ))
    }

    /// Construct a new `PaintVarScaleUniformAroundCenter` subtable
    pub fn var_scale_uniform_around_center(
        paint: Paint,
        scale: F2Dot14,
        center_x: FWord,
        center_y: FWord,
        var_index_base: u32,
    ) -> Self {
        Self::VarScaleUniformAroundCenter(PaintVarScaleUniformAroundCenter::new(
            paint,
            scale,
            center_x,
            center_y,
            var_index_base,
        ))
    }

    /// Construct a new `PaintRotate` subtable
    pub fn rotate(paint: Paint, angle: F2Dot14) -> Self {
        Self::Rotate(PaintRotate::new(paint, angle))
    }

    /// Construct a new `PaintVarRotate` subtable
    pub fn var_rotate(paint: Paint, angle: F2Dot14, var_index_base: u32) -> Self {
        Self::VarRotate(PaintVarRotate::new(paint, angle, var_index_base))
    }

    /// Construct a new `PaintRotateAroundCenter` subtable
    pub fn rotate_around_center(
        paint: Paint,
        angle: F2Dot14,
        center_x: FWord,
        center_y: FWord,
    ) -> Self {
        Self::RotateAroundCenter(PaintRotateAroundCenter::new(
            paint, angle, center_x, center_y,
        ))
    }

    /// Construct a new `PaintVarRotateAroundCenter` subtable
    pub fn var_rotate_around_center(
        paint: Paint,
        angle: F2Dot14,
        center_x: FWord,
        center_y: FWord,
        var_index_base: u32,
    ) -> Self {
        Self::VarRotateAroundCenter(PaintVarRotateAroundCenter::new(
            paint,
            angle,
            center_x,
            center_y,
            var_index_base,
        ))
    }

    /// Construct a new `PaintSkew` subtable
    pub fn skew(paint: Paint, x_skew_angle: F2Dot14, y_skew_angle: F2Dot14) -> Self {
        Self::Skew(PaintSkew::new(paint, x_skew_angle, y_skew_angle))
    }

    /// Construct a new `PaintVarSkew` subtable
    pub fn var_skew(
        paint: Paint,
        x_skew_angle: F2Dot14,
        y_skew_angle: F2Dot14,
        var_index_base: u32,
    ) -> Self {
        Self::VarSkew(PaintVarSkew::new(
            paint,
            x_skew_angle,
            y_skew_angle,
            var_index_base,
        ))
    }

    /// Construct a new `PaintSkewAroundCenter` subtable
    pub fn skew_around_center(
        paint: Paint,
        x_skew_angle: F2Dot14,
        y_skew_angle: F2Dot14,
        center_x: FWord,
        center_y: FWord,
    ) -> Self {
        Self::SkewAroundCenter(PaintSkewAroundCenter::new(
            paint,
            x_skew_angle,
            y_skew_angle,
            center_x,
            center_y,
        ))
    }

    /// Construct a new `PaintVarSkewAroundCenter` subtable
    pub fn var_skew_around_center(
        paint: Paint,
        x_skew_angle: F2Dot14,
        y_skew_angle: F2Dot14,
        center_x: FWord,
        center_y: FWord,
        var_index_base: u32,
    ) -> Self {
        Self::VarSkewAroundCenter(PaintVarSkewAroundCenter::new(
            paint,
            x_skew_angle,
            y_skew_angle,
            center_x,
            center_y,
            var_index_base,
        ))
    }

    /// Construct a new `PaintComposite` subtable
    pub fn composite(
        source_paint: Paint,
        composite_mode: CompositeMode,
        backdrop_paint: Paint,
    ) -> Self {
        Self::Composite(PaintComposite::new(
            source_paint,
            composite_mode,
            backdrop_paint,
        ))
    }
}

impl Default for Paint {
    fn default() -> Self {
        Self::ColrLayers(Default::default())
    }
}

impl FontWrite for Paint {
    fn write_into(&self, writer: &mut TableWriter) {
        match self {
            Self::ColrLayers(item) => item.write_into(writer),
            Self::Solid(item) => item.write_into(writer),
            Self::VarSolid(item) => item.write_into(writer),
            Self::LinearGradient(item) => item.write_into(writer),
            Self::VarLinearGradient(item) => item.write_into(writer),
            Self::RadialGradient(item) => item.write_into(writer),
            Self::VarRadialGradient(item) => item.write_into(writer),
            Self::SweepGradient(item) => item.write_into(writer),
            Self::VarSweepGradient(item) => item.write_into(writer),
            Self::Glyph(item) => item.write_into(writer),
            Self::ColrGlyph(item) => item.write_into(writer),
            Self::Transform(item) => item.write_into(writer),
            Self::VarTransform(item) => item.write_into(writer),
            Self::Translate(item) => item.write_into(writer),
            Self::VarTranslate(item) => item.write_into(writer),
            Self::Scale(item) => item.write_into(writer),
            Self::VarScale(item) => item.write_into(writer),
            Self::ScaleAroundCenter(item) => item.write_into(writer),
            Self::VarScaleAroundCenter(item) => item.write_into(writer),
            Self::ScaleUniform(item) => item.write_into(writer),
            Self::VarScaleUniform(item) => item.write_into(writer),
            Self::ScaleUniformAroundCenter(item) => item.write_into(writer),
            Self::VarScaleUniformAroundCenter(item) => item.write_into(writer),
            Self::Rotate(item) => item.write_into(writer),
            Self::VarRotate(item) => item.write_into(writer),
            Self::RotateAroundCenter(item) => item.write_into(writer),
            Self::VarRotateAroundCenter(item) => item.write_into(writer),
            Self::Skew(item) => item.write_into(writer),
            Self::VarSkew(item) => item.write_into(writer),
            Self::SkewAroundCenter(item) => item.write_into(writer),
            Self::VarSkewAroundCenter(item) => item.write_into(writer),
            Self::Composite(item) => item.write_into(writer),
        }
    }
    fn table_type(&self) -> TableType {
        match self {
            Self::ColrLayers(item) => item.table_type(),
            Self::Solid(item) => item.table_type(),
            Self::VarSolid(item) => item.table_type(),
            Self::LinearGradient(item) => item.table_type(),
            Self::VarLinearGradient(item) => item.table_type(),
            Self::RadialGradient(item) => item.table_type(),
            Self::VarRadialGradient(item) => item.table_type(),
            Self::SweepGradient(item) => item.table_type(),
            Self::VarSweepGradient(item) => item.table_type(),
            Self::Glyph(item) => item.table_type(),
            Self::ColrGlyph(item) => item.table_type(),
            Self::Transform(item) => item.table_type(),
            Self::VarTransform(item) => item.table_type(),
            Self::Translate(item) => item.table_type(),
            Self::VarTranslate(item) => item.table_type(),
            Self::Scale(item) => item.table_type(),
            Self::VarScale(item) => item.table_type(),
            Self::ScaleAroundCenter(item) => item.table_type(),
            Self::VarScaleAroundCenter(item) => item.table_type(),
            Self::ScaleUniform(item) => item.table_type(),
            Self::VarScaleUniform(item) => item.table_type(),
            Self::ScaleUniformAroundCenter(item) => item.table_type(),
            Self::VarScaleUniformAroundCenter(item) => item.table_type(),
            Self::Rotate(item) => item.table_type(),
            Self::VarRotate(item) => item.table_type(),
            Self::RotateAroundCenter(item) => item.table_type(),
            Self::VarRotateAroundCenter(item) => item.table_type(),
            Self::Skew(item) => item.table_type(),
            Self::VarSkew(item) => item.table_type(),
            Self::SkewAroundCenter(item) => item.table_type(),
            Self::VarSkewAroundCenter(item) => item.table_type(),
            Self::Composite(item) => item.table_type(),
        }
    }
}

impl Validate for Paint {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        match self {
            Self::ColrLayers(item) => item.validate_impl(ctx),
            Self::Solid(item) => item.validate_impl(ctx),
            Self::VarSolid(item) => item.validate_impl(ctx),
            Self::LinearGradient(item) => item.validate_impl(ctx),
            Self::VarLinearGradient(item) => item.validate_impl(ctx),
            Self::RadialGradient(item) => item.validate_impl(ctx),
            Self::VarRadialGradient(item) => item.validate_impl(ctx),
            Self::SweepGradient(item) => item.validate_impl(ctx),
            Self::VarSweepGradient(item) => item.validate_impl(ctx),
            Self::Glyph(item) => item.validate_impl(ctx),
            Self::ColrGlyph(item) => item.validate_impl(ctx),
            Self::Transform(item) => item.validate_impl(ctx),
            Self::VarTransform(item) => item.validate_impl(ctx),
            Self::Translate(item) => item.validate_impl(ctx),
            Self::VarTranslate(item) => item.validate_impl(ctx),
            Self::Scale(item) => item.validate_impl(ctx),
            Self::VarScale(item) => item.validate_impl(ctx),
            Self::ScaleAroundCenter(item) => item.validate_impl(ctx),
            Self::VarScaleAroundCenter(item) => item.validate_impl(ctx),
            Self::ScaleUniform(item) => item.validate_impl(ctx),
            Self::VarScaleUniform(item) => item.validate_impl(ctx),
            Self::ScaleUniformAroundCenter(item) => item.validate_impl(ctx),
            Self::VarScaleUniformAroundCenter(item) => item.validate_impl(ctx),
            Self::Rotate(item) => item.validate_impl(ctx),
            Self::VarRotate(item) => item.validate_impl(ctx),
            Self::RotateAroundCenter(item) => item.validate_impl(ctx),
            Self::VarRotateAroundCenter(item) => item.validate_impl(ctx),
            Self::Skew(item) => item.validate_impl(ctx),
            Self::VarSkew(item) => item.validate_impl(ctx),
            Self::SkewAroundCenter(item) => item.validate_impl(ctx),
            Self::VarSkewAroundCenter(item) => item.validate_impl(ctx),
            Self::Composite(item) => item.validate_impl(ctx),
        }
    }
}

impl FromObjRef<read_fonts::tables::colr::Paint<'_>> for Paint {
    fn from_obj_ref(obj: &read_fonts::tables::colr::Paint, _: FontData) -> Self {
        use read_fonts::tables::colr::Paint as ObjRefType;
        match obj {
            ObjRefType::ColrLayers(item) => Paint::ColrLayers(item.to_owned_table()),
            ObjRefType::Solid(item) => Paint::Solid(item.to_owned_table()),
            ObjRefType::VarSolid(item) => Paint::VarSolid(item.to_owned_table()),
            ObjRefType::LinearGradient(item) => Paint::LinearGradient(item.to_owned_table()),
            ObjRefType::VarLinearGradient(item) => Paint::VarLinearGradient(item.to_owned_table()),
            ObjRefType::RadialGradient(item) => Paint::RadialGradient(item.to_owned_table()),
            ObjRefType::VarRadialGradient(item) => Paint::VarRadialGradient(item.to_owned_table()),
            ObjRefType::SweepGradient(item) => Paint::SweepGradient(item.to_owned_table()),
            ObjRefType::VarSweepGradient(item) => Paint::VarSweepGradient(item.to_owned_table()),
            ObjRefType::Glyph(item) => Paint::Glyph(item.to_owned_table()),
            ObjRefType::ColrGlyph(item) => Paint::ColrGlyph(item.to_owned_table()),
            ObjRefType::Transform(item) => Paint::Transform(item.to_owned_table()),
            ObjRefType::VarTransform(item) => Paint::VarTransform(item.to_owned_table()),
            ObjRefType::Translate(item) => Paint::Translate(item.to_owned_table()),
            ObjRefType::VarTranslate(item) => Paint::VarTranslate(item.to_owned_table()),
            ObjRefType::Scale(item) => Paint::Scale(item.to_owned_table()),
            ObjRefType::VarScale(item) => Paint::VarScale(item.to_owned_table()),
            ObjRefType::ScaleAroundCenter(item) => Paint::ScaleAroundCenter(item.to_owned_table()),
            ObjRefType::VarScaleAroundCenter(item) => {
                Paint::VarScaleAroundCenter(item.to_owned_table())
            }
            ObjRefType::ScaleUniform(item) => Paint::ScaleUniform(item.to_owned_table()),
            ObjRefType::VarScaleUniform(item) => Paint::VarScaleUniform(item.to_owned_table()),
            ObjRefType::ScaleUniformAroundCenter(item) => {
                Paint::ScaleUniformAroundCenter(item.to_owned_table())
            }
            ObjRefType::VarScaleUniformAroundCenter(item) => {
                Paint::VarScaleUniformAroundCenter(item.to_owned_table())
            }
            ObjRefType::Rotate(item) => Paint::Rotate(item.to_owned_table()),
            ObjRefType::VarRotate(item) => Paint::VarRotate(item.to_owned_table()),
            ObjRefType::RotateAroundCenter(item) => {
                Paint::RotateAroundCenter(item.to_owned_table())
            }
            ObjRefType::VarRotateAroundCenter(item) => {
                Paint::VarRotateAroundCenter(item.to_owned_table())
            }
            ObjRefType::Skew(item) => Paint::Skew(item.to_owned_table()),
            ObjRefType::VarSkew(item) => Paint::VarSkew(item.to_owned_table()),
            ObjRefType::SkewAroundCenter(item) => Paint::SkewAroundCenter(item.to_owned_table()),
            ObjRefType::VarSkewAroundCenter(item) => {
                Paint::VarSkewAroundCenter(item.to_owned_table())
            }
            ObjRefType::Composite(item) => Paint::Composite(item.to_owned_table()),
        }
    }
}

impl FromTableRef<read_fonts::tables::colr::Paint<'_>> for Paint {}

impl<'a> FontRead<'a> for Paint {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::Paint as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

impl From<PaintColrLayers> for Paint {
    fn from(src: PaintColrLayers) -> Paint {
        Paint::ColrLayers(src)
    }
}

impl From<PaintSolid> for Paint {
    fn from(src: PaintSolid) -> Paint {
        Paint::Solid(src)
    }
}

impl From<PaintVarSolid> for Paint {
    fn from(src: PaintVarSolid) -> Paint {
        Paint::VarSolid(src)
    }
}

impl From<PaintLinearGradient> for Paint {
    fn from(src: PaintLinearGradient) -> Paint {
        Paint::LinearGradient(src)
    }
}

impl From<PaintVarLinearGradient> for Paint {
    fn from(src: PaintVarLinearGradient) -> Paint {
        Paint::VarLinearGradient(src)
    }
}

impl From<PaintRadialGradient> for Paint {
    fn from(src: PaintRadialGradient) -> Paint {
        Paint::RadialGradient(src)
    }
}

impl From<PaintVarRadialGradient> for Paint {
    fn from(src: PaintVarRadialGradient) -> Paint {
        Paint::VarRadialGradient(src)
    }
}

impl From<PaintSweepGradient> for Paint {
    fn from(src: PaintSweepGradient) -> Paint {
        Paint::SweepGradient(src)
    }
}

impl From<PaintVarSweepGradient> for Paint {
    fn from(src: PaintVarSweepGradient) -> Paint {
        Paint::VarSweepGradient(src)
    }
}

impl From<PaintGlyph> for Paint {
    fn from(src: PaintGlyph) -> Paint {
        Paint::Glyph(src)
    }
}

impl From<PaintColrGlyph> for Paint {
    fn from(src: PaintColrGlyph) -> Paint {
        Paint::ColrGlyph(src)
    }
}

impl From<PaintTransform> for Paint {
    fn from(src: PaintTransform) -> Paint {
        Paint::Transform(src)
    }
}

impl From<PaintVarTransform> for Paint {
    fn from(src: PaintVarTransform) -> Paint {
        Paint::VarTransform(src)
    }
}

impl From<PaintTranslate> for Paint {
    fn from(src: PaintTranslate) -> Paint {
        Paint::Translate(src)
    }
}

impl From<PaintVarTranslate> for Paint {
    fn from(src: PaintVarTranslate) -> Paint {
        Paint::VarTranslate(src)
    }
}

impl From<PaintScale> for Paint {
    fn from(src: PaintScale) -> Paint {
        Paint::Scale(src)
    }
}

impl From<PaintVarScale> for Paint {
    fn from(src: PaintVarScale) -> Paint {
        Paint::VarScale(src)
    }
}

impl From<PaintScaleAroundCenter> for Paint {
    fn from(src: PaintScaleAroundCenter) -> Paint {
        Paint::ScaleAroundCenter(src)
    }
}

impl From<PaintVarScaleAroundCenter> for Paint {
    fn from(src: PaintVarScaleAroundCenter) -> Paint {
        Paint::VarScaleAroundCenter(src)
    }
}

impl From<PaintScaleUniform> for Paint {
    fn from(src: PaintScaleUniform) -> Paint {
        Paint::ScaleUniform(src)
    }
}

impl From<PaintVarScaleUniform> for Paint {
    fn from(src: PaintVarScaleUniform) -> Paint {
        Paint::VarScaleUniform(src)
    }
}

impl From<PaintScaleUniformAroundCenter> for Paint {
    fn from(src: PaintScaleUniformAroundCenter) -> Paint {
        Paint::ScaleUniformAroundCenter(src)
    }
}

impl From<PaintVarScaleUniformAroundCenter> for Paint {
    fn from(src: PaintVarScaleUniformAroundCenter) -> Paint {
        Paint::VarScaleUniformAroundCenter(src)
    }
}

impl From<PaintRotate> for Paint {
    fn from(src: PaintRotate) -> Paint {
        Paint::Rotate(src)
    }
}

impl From<PaintVarRotate> for Paint {
    fn from(src: PaintVarRotate) -> Paint {
        Paint::VarRotate(src)
    }
}

impl From<PaintRotateAroundCenter> for Paint {
    fn from(src: PaintRotateAroundCenter) -> Paint {
        Paint::RotateAroundCenter(src)
    }
}

impl From<PaintVarRotateAroundCenter> for Paint {
    fn from(src: PaintVarRotateAroundCenter) -> Paint {
        Paint::VarRotateAroundCenter(src)
    }
}

impl From<PaintSkew> for Paint {
    fn from(src: PaintSkew) -> Paint {
        Paint::Skew(src)
    }
}

impl From<PaintVarSkew> for Paint {
    fn from(src: PaintVarSkew) -> Paint {
        Paint::VarSkew(src)
    }
}

impl From<PaintSkewAroundCenter> for Paint {
    fn from(src: PaintSkewAroundCenter) -> Paint {
        Paint::SkewAroundCenter(src)
    }
}

impl From<PaintVarSkewAroundCenter> for Paint {
    fn from(src: PaintVarSkewAroundCenter) -> Paint {
        Paint::VarSkewAroundCenter(src)
    }
}

impl From<PaintComposite> for Paint {
    fn from(src: PaintComposite) -> Paint {
        Paint::Composite(src)
    }
}

/// [PaintColrLayers](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#format-1-paintcolrlayers) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintColrLayers {
    /// Number of offsets to paint tables to read from LayerList.
    pub num_layers: u8,
    /// Index (base 0) into the LayerList.
    pub first_layer_index: u32,
}

impl PaintColrLayers {
    /// Construct a new `PaintColrLayers`
    pub fn new(num_layers: u8, first_layer_index: u32) -> Self {
        Self {
            num_layers,
            first_layer_index,
        }
    }
}

impl FontWrite for PaintColrLayers {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u8).write_into(writer);
        self.num_layers.write_into(writer);
        self.first_layer_index.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintColrLayers")
    }
}

impl Validate for PaintColrLayers {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintColrLayers<'a>> for PaintColrLayers {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintColrLayers<'a>, _: FontData) -> Self {
        PaintColrLayers {
            num_layers: obj.num_layers(),
            first_layer_index: obj.first_layer_index(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintColrLayers<'a>> for PaintColrLayers {}

impl<'a> FontRead<'a> for PaintColrLayers {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintColrLayers as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintSolid](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-2-and-3-paintsolid-paintvarsolid) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintSolid {
    /// Index for a CPAL palette entry.
    pub palette_index: u16,
    /// Alpha value.
    pub alpha: F2Dot14,
}

impl PaintSolid {
    /// Construct a new `PaintSolid`
    pub fn new(palette_index: u16, alpha: F2Dot14) -> Self {
        Self {
            palette_index,
            alpha,
        }
    }
}

impl FontWrite for PaintSolid {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (2 as u8).write_into(writer);
        self.palette_index.write_into(writer);
        self.alpha.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintSolid")
    }
}

impl Validate for PaintSolid {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintSolid<'a>> for PaintSolid {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintSolid<'a>, _: FontData) -> Self {
        PaintSolid {
            palette_index: obj.palette_index(),
            alpha: obj.alpha(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintSolid<'a>> for PaintSolid {}

impl<'a> FontRead<'a> for PaintSolid {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintSolid as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [PaintVarSolid](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-2-and-3-paintsolid-paintvarsolid) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarSolid {
    /// Index for a CPAL palette entry.
    pub palette_index: u16,
    /// Alpha value. For variation, use varIndexBase + 0.
    pub alpha: F2Dot14,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarSolid {
    /// Construct a new `PaintVarSolid`
    pub fn new(palette_index: u16, alpha: F2Dot14, var_index_base: u32) -> Self {
        Self {
            palette_index,
            alpha,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarSolid {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (3 as u8).write_into(writer);
        self.palette_index.write_into(writer);
        self.alpha.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarSolid")
    }
}

impl Validate for PaintVarSolid {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarSolid<'a>> for PaintVarSolid {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintVarSolid<'a>, _: FontData) -> Self {
        PaintVarSolid {
            palette_index: obj.palette_index(),
            alpha: obj.alpha(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarSolid<'a>> for PaintVarSolid {}

impl<'a> FontRead<'a> for PaintVarSolid {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarSolid as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintLinearGradient](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-4-and-5-paintlineargradient-paintvarlineargradient) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintLinearGradient {
    /// Offset to ColorLine table.
    pub color_line: OffsetMarker<ColorLine, WIDTH_24>,
    /// Start point (p₀) x coordinate.
    pub x0: FWord,
    /// Start point (p₀) y coordinate.
    pub y0: FWord,
    /// End point (p₁) x coordinate.
    pub x1: FWord,
    /// End point (p₁) y coordinate.
    pub y1: FWord,
    /// Rotation point (p₂) x coordinate.
    pub x2: FWord,
    /// Rotation point (p₂) y coordinate.
    pub y2: FWord,
}

impl PaintLinearGradient {
    /// Construct a new `PaintLinearGradient`
    pub fn new(
        color_line: ColorLine,
        x0: FWord,
        y0: FWord,
        x1: FWord,
        y1: FWord,
        x2: FWord,
        y2: FWord,
    ) -> Self {
        Self {
            color_line: color_line.into(),
            x0,
            y0,
            x1,
            y1,
            x2,
            y2,
        }
    }
}

impl FontWrite for PaintLinearGradient {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (4 as u8).write_into(writer);
        self.color_line.write_into(writer);
        self.x0.write_into(writer);
        self.y0.write_into(writer);
        self.x1.write_into(writer);
        self.y1.write_into(writer);
        self.x2.write_into(writer);
        self.y2.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintLinearGradient")
    }
}

impl Validate for PaintLinearGradient {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintLinearGradient", |ctx| {
            ctx.in_field("color_line", |ctx| {
                self.color_line.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintLinearGradient<'a>> for PaintLinearGradient {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintLinearGradient<'a>, _: FontData) -> Self {
        PaintLinearGradient {
            color_line: obj.color_line().to_owned_table(),
            x0: obj.x0(),
            y0: obj.y0(),
            x1: obj.x1(),
            y1: obj.y1(),
            x2: obj.x2(),
            y2: obj.y2(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintLinearGradient<'a>> for PaintLinearGradient {}

impl<'a> FontRead<'a> for PaintLinearGradient {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintLinearGradient as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarLinearGradient](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-4-and-5-paintlineargradient-paintvarlineargradient) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarLinearGradient {
    /// Offset to VarColorLine table.
    pub color_line: OffsetMarker<VarColorLine, WIDTH_24>,
    /// Start point (p₀) x coordinate. For variation, use
    /// varIndexBase + 0.
    pub x0: FWord,
    /// Start point (p₀) y coordinate. For variation, use
    /// varIndexBase + 1.
    pub y0: FWord,
    /// End point (p₁) x coordinate. For variation, use varIndexBase
    /// + 2.
    pub x1: FWord,
    /// End point (p₁) y coordinate. For variation, use varIndexBase
    /// + 3.
    pub y1: FWord,
    /// Rotation point (p₂) x coordinate. For variation, use
    /// varIndexBase + 4.
    pub x2: FWord,
    /// Rotation point (p₂) y coordinate. For variation, use
    /// varIndexBase + 5.
    pub y2: FWord,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarLinearGradient {
    /// Construct a new `PaintVarLinearGradient`
    #[allow(clippy::too_many_arguments)]
    pub fn new(
        color_line: VarColorLine,
        x0: FWord,
        y0: FWord,
        x1: FWord,
        y1: FWord,
        x2: FWord,
        y2: FWord,
        var_index_base: u32,
    ) -> Self {
        Self {
            color_line: color_line.into(),
            x0,
            y0,
            x1,
            y1,
            x2,
            y2,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarLinearGradient {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (5 as u8).write_into(writer);
        self.color_line.write_into(writer);
        self.x0.write_into(writer);
        self.y0.write_into(writer);
        self.x1.write_into(writer);
        self.y1.write_into(writer);
        self.x2.write_into(writer);
        self.y2.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarLinearGradient")
    }
}

impl Validate for PaintVarLinearGradient {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarLinearGradient", |ctx| {
            ctx.in_field("color_line", |ctx| {
                self.color_line.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarLinearGradient<'a>>
    for PaintVarLinearGradient
{
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintVarLinearGradient<'a>,
        _: FontData,
    ) -> Self {
        PaintVarLinearGradient {
            color_line: obj.color_line().to_owned_table(),
            x0: obj.x0(),
            y0: obj.y0(),
            x1: obj.x1(),
            y1: obj.y1(),
            x2: obj.x2(),
            y2: obj.y2(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarLinearGradient<'a>>
    for PaintVarLinearGradient
{
}

impl<'a> FontRead<'a> for PaintVarLinearGradient {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarLinearGradient as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintRadialGradient](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-6-and-7-paintradialgradient-paintvarradialgradient) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintRadialGradient {
    /// Offset to ColorLine table.
    pub color_line: OffsetMarker<ColorLine, WIDTH_24>,
    /// Start circle center x coordinate.
    pub x0: FWord,
    /// Start circle center y coordinate.
    pub y0: FWord,
    /// Start circle radius.
    pub radius0: UfWord,
    /// End circle center x coordinate.
    pub x1: FWord,
    /// End circle center y coordinate.
    pub y1: FWord,
    /// End circle radius.
    pub radius1: UfWord,
}

impl PaintRadialGradient {
    /// Construct a new `PaintRadialGradient`
    pub fn new(
        color_line: ColorLine,
        x0: FWord,
        y0: FWord,
        radius0: UfWord,
        x1: FWord,
        y1: FWord,
        radius1: UfWord,
    ) -> Self {
        Self {
            color_line: color_line.into(),
            x0,
            y0,
            radius0,
            x1,
            y1,
            radius1,
        }
    }
}

impl FontWrite for PaintRadialGradient {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (6 as u8).write_into(writer);
        self.color_line.write_into(writer);
        self.x0.write_into(writer);
        self.y0.write_into(writer);
        self.radius0.write_into(writer);
        self.x1.write_into(writer);
        self.y1.write_into(writer);
        self.radius1.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintRadialGradient")
    }
}

impl Validate for PaintRadialGradient {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintRadialGradient", |ctx| {
            ctx.in_field("color_line", |ctx| {
                self.color_line.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintRadialGradient<'a>> for PaintRadialGradient {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintRadialGradient<'a>, _: FontData) -> Self {
        PaintRadialGradient {
            color_line: obj.color_line().to_owned_table(),
            x0: obj.x0(),
            y0: obj.y0(),
            radius0: obj.radius0(),
            x1: obj.x1(),
            y1: obj.y1(),
            radius1: obj.radius1(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintRadialGradient<'a>> for PaintRadialGradient {}

impl<'a> FontRead<'a> for PaintRadialGradient {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintRadialGradient as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarRadialGradient](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-6-and-7-paintradialgradient-paintvarradialgradient) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarRadialGradient {
    /// Offset to VarColorLine table.
    pub color_line: OffsetMarker<VarColorLine, WIDTH_24>,
    /// Start circle center x coordinate. For variation, use
    /// varIndexBase + 0.
    pub x0: FWord,
    /// Start circle center y coordinate. For variation, use
    /// varIndexBase + 1.
    pub y0: FWord,
    /// Start circle radius. For variation, use varIndexBase + 2.
    pub radius0: UfWord,
    /// End circle center x coordinate. For variation, use varIndexBase
    /// + 3.
    pub x1: FWord,
    /// End circle center y coordinate. For variation, use varIndexBase
    /// + 4.
    pub y1: FWord,
    /// End circle radius. For variation, use varIndexBase + 5.
    pub radius1: UfWord,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarRadialGradient {
    /// Construct a new `PaintVarRadialGradient`
    #[allow(clippy::too_many_arguments)]
    pub fn new(
        color_line: VarColorLine,
        x0: FWord,
        y0: FWord,
        radius0: UfWord,
        x1: FWord,
        y1: FWord,
        radius1: UfWord,
        var_index_base: u32,
    ) -> Self {
        Self {
            color_line: color_line.into(),
            x0,
            y0,
            radius0,
            x1,
            y1,
            radius1,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarRadialGradient {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (7 as u8).write_into(writer);
        self.color_line.write_into(writer);
        self.x0.write_into(writer);
        self.y0.write_into(writer);
        self.radius0.write_into(writer);
        self.x1.write_into(writer);
        self.y1.write_into(writer);
        self.radius1.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarRadialGradient")
    }
}

impl Validate for PaintVarRadialGradient {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarRadialGradient", |ctx| {
            ctx.in_field("color_line", |ctx| {
                self.color_line.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarRadialGradient<'a>>
    for PaintVarRadialGradient
{
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintVarRadialGradient<'a>,
        _: FontData,
    ) -> Self {
        PaintVarRadialGradient {
            color_line: obj.color_line().to_owned_table(),
            x0: obj.x0(),
            y0: obj.y0(),
            radius0: obj.radius0(),
            x1: obj.x1(),
            y1: obj.y1(),
            radius1: obj.radius1(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarRadialGradient<'a>>
    for PaintVarRadialGradient
{
}

impl<'a> FontRead<'a> for PaintVarRadialGradient {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarRadialGradient as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintSweepGradient](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-8-and-9-paintsweepgradient-paintvarsweepgradient) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintSweepGradient {
    /// Offset to ColorLine table.
    pub color_line: OffsetMarker<ColorLine, WIDTH_24>,
    /// Center x coordinate.
    pub center_x: FWord,
    /// Center y coordinate.
    pub center_y: FWord,
    /// Start of the angular range of the gradient, 180° in
    /// counter-clockwise degrees per 1.0 of value.
    pub start_angle: F2Dot14,
    /// End of the angular range of the gradient, 180° in
    /// counter-clockwise degrees per 1.0 of value.
    pub end_angle: F2Dot14,
}

impl PaintSweepGradient {
    /// Construct a new `PaintSweepGradient`
    pub fn new(
        color_line: ColorLine,
        center_x: FWord,
        center_y: FWord,
        start_angle: F2Dot14,
        end_angle: F2Dot14,
    ) -> Self {
        Self {
            color_line: color_line.into(),
            center_x,
            center_y,
            start_angle,
            end_angle,
        }
    }
}

impl FontWrite for PaintSweepGradient {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (8 as u8).write_into(writer);
        self.color_line.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
        self.start_angle.write_into(writer);
        self.end_angle.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintSweepGradient")
    }
}

impl Validate for PaintSweepGradient {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintSweepGradient", |ctx| {
            ctx.in_field("color_line", |ctx| {
                self.color_line.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintSweepGradient<'a>> for PaintSweepGradient {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintSweepGradient<'a>, _: FontData) -> Self {
        PaintSweepGradient {
            color_line: obj.color_line().to_owned_table(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
            start_angle: obj.start_angle(),
            end_angle: obj.end_angle(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintSweepGradient<'a>> for PaintSweepGradient {}

impl<'a> FontRead<'a> for PaintSweepGradient {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintSweepGradient as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarSweepGradient](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-8-and-9-paintsweepgradient-paintvarsweepgradient) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarSweepGradient {
    /// Offset to VarColorLine table.
    pub color_line: OffsetMarker<VarColorLine, WIDTH_24>,
    /// Center x coordinate. For variation, use varIndexBase + 0.
    pub center_x: FWord,
    /// Center y coordinate. For variation, use varIndexBase + 1.
    pub center_y: FWord,
    /// Start of the angular range of the gradient, 180° in
    /// counter-clockwise degrees per 1.0 of value. For variation, use
    /// varIndexBase + 2.
    pub start_angle: F2Dot14,
    /// End of the angular range of the gradient, 180° in
    /// counter-clockwise degrees per 1.0 of value. For variation, use
    /// varIndexBase + 3.
    pub end_angle: F2Dot14,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarSweepGradient {
    /// Construct a new `PaintVarSweepGradient`
    pub fn new(
        color_line: VarColorLine,
        center_x: FWord,
        center_y: FWord,
        start_angle: F2Dot14,
        end_angle: F2Dot14,
        var_index_base: u32,
    ) -> Self {
        Self {
            color_line: color_line.into(),
            center_x,
            center_y,
            start_angle,
            end_angle,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarSweepGradient {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (9 as u8).write_into(writer);
        self.color_line.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
        self.start_angle.write_into(writer);
        self.end_angle.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarSweepGradient")
    }
}

impl Validate for PaintVarSweepGradient {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarSweepGradient", |ctx| {
            ctx.in_field("color_line", |ctx| {
                self.color_line.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarSweepGradient<'a>> for PaintVarSweepGradient {
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintVarSweepGradient<'a>,
        _: FontData,
    ) -> Self {
        PaintVarSweepGradient {
            color_line: obj.color_line().to_owned_table(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
            start_angle: obj.start_angle(),
            end_angle: obj.end_angle(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarSweepGradient<'a>>
    for PaintVarSweepGradient
{
}

impl<'a> FontRead<'a> for PaintVarSweepGradient {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarSweepGradient as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintGlyph](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#format-10-paintglyph) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintGlyph {
    /// Offset to a Paint table.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Glyph ID for the source outline.
    pub glyph_id: GlyphId16,
}

impl PaintGlyph {
    /// Construct a new `PaintGlyph`
    pub fn new(paint: Paint, glyph_id: GlyphId16) -> Self {
        Self {
            paint: paint.into(),
            glyph_id,
        }
    }
}

impl FontWrite for PaintGlyph {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (10 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.glyph_id.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintGlyph")
    }
}

impl Validate for PaintGlyph {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintGlyph", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintGlyph<'a>> for PaintGlyph {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintGlyph<'a>, _: FontData) -> Self {
        PaintGlyph {
            paint: obj.paint().to_owned_table(),
            glyph_id: obj.glyph_id(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintGlyph<'a>> for PaintGlyph {}

impl<'a> FontRead<'a> for PaintGlyph {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintGlyph as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [PaintColrGlyph](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#format-11-paintcolrglyph) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintColrGlyph {
    /// Glyph ID for a BaseGlyphList base glyph.
    pub glyph_id: GlyphId16,
}

impl PaintColrGlyph {
    /// Construct a new `PaintColrGlyph`
    pub fn new(glyph_id: GlyphId16) -> Self {
        Self { glyph_id }
    }
}

impl FontWrite for PaintColrGlyph {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (11 as u8).write_into(writer);
        self.glyph_id.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintColrGlyph")
    }
}

impl Validate for PaintColrGlyph {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintColrGlyph<'a>> for PaintColrGlyph {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintColrGlyph<'a>, _: FontData) -> Self {
        PaintColrGlyph {
            glyph_id: obj.glyph_id(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintColrGlyph<'a>> for PaintColrGlyph {}

impl<'a> FontRead<'a> for PaintColrGlyph {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintColrGlyph as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintTransform](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-12-and-13-painttransform-paintvartransform) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintTransform {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Offset to an Affine2x3 table.
    pub transform: OffsetMarker<Affine2x3, WIDTH_24>,
}

impl PaintTransform {
    /// Construct a new `PaintTransform`
    pub fn new(paint: Paint, transform: Affine2x3) -> Self {
        Self {
            paint: paint.into(),
            transform: transform.into(),
        }
    }
}

impl FontWrite for PaintTransform {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (12 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.transform.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintTransform")
    }
}

impl Validate for PaintTransform {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintTransform", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
            ctx.in_field("transform", |ctx| {
                self.transform.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintTransform<'a>> for PaintTransform {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintTransform<'a>, _: FontData) -> Self {
        PaintTransform {
            paint: obj.paint().to_owned_table(),
            transform: obj.transform().to_owned_table(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintTransform<'a>> for PaintTransform {}

impl<'a> FontRead<'a> for PaintTransform {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintTransform as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarTransform](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-12-and-13-painttransform-paintvartransform) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarTransform {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Offset to a VarAffine2x3 table.
    pub transform: OffsetMarker<VarAffine2x3, WIDTH_24>,
}

impl PaintVarTransform {
    /// Construct a new `PaintVarTransform`
    pub fn new(paint: Paint, transform: VarAffine2x3) -> Self {
        Self {
            paint: paint.into(),
            transform: transform.into(),
        }
    }
}

impl FontWrite for PaintVarTransform {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (13 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.transform.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarTransform")
    }
}

impl Validate for PaintVarTransform {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarTransform", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
            ctx.in_field("transform", |ctx| {
                self.transform.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarTransform<'a>> for PaintVarTransform {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintVarTransform<'a>, _: FontData) -> Self {
        PaintVarTransform {
            paint: obj.paint().to_owned_table(),
            transform: obj.transform().to_owned_table(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarTransform<'a>> for PaintVarTransform {}

impl<'a> FontRead<'a> for PaintVarTransform {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarTransform as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [Affine2x3](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-12-and-13-painttransform-paintvartransform) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Affine2x3 {
    /// x-component of transformed x-basis vector.
    pub xx: Fixed,
    /// y-component of transformed x-basis vector.
    pub yx: Fixed,
    /// x-component of transformed y-basis vector.
    pub xy: Fixed,
    /// y-component of transformed y-basis vector.
    pub yy: Fixed,
    /// Translation in x direction.
    pub dx: Fixed,
    /// Translation in y direction.
    pub dy: Fixed,
}

impl Affine2x3 {
    /// Construct a new `Affine2x3`
    pub fn new(xx: Fixed, yx: Fixed, xy: Fixed, yy: Fixed, dx: Fixed, dy: Fixed) -> Self {
        Self {
            xx,
            yx,
            xy,
            yy,
            dx,
            dy,
        }
    }
}

impl FontWrite for Affine2x3 {
    fn write_into(&self, writer: &mut TableWriter) {
        self.xx.write_into(writer);
        self.yx.write_into(writer);
        self.xy.write_into(writer);
        self.yy.write_into(writer);
        self.dx.write_into(writer);
        self.dy.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("Affine2x3")
    }
}

impl Validate for Affine2x3 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::colr::Affine2x3<'a>> for Affine2x3 {
    fn from_obj_ref(obj: &read_fonts::tables::colr::Affine2x3<'a>, _: FontData) -> Self {
        Affine2x3 {
            xx: obj.xx(),
            yx: obj.yx(),
            xy: obj.xy(),
            yy: obj.yy(),
            dx: obj.dx(),
            dy: obj.dy(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::Affine2x3<'a>> for Affine2x3 {}

impl<'a> FontRead<'a> for Affine2x3 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::Affine2x3 as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [VarAffine2x3](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-12-and-13-painttransform-paintvartransform) record
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct VarAffine2x3 {
    /// x-component of transformed x-basis vector. For variation, use
    /// varIndexBase + 0.
    pub xx: Fixed,
    /// y-component of transformed x-basis vector. For variation, use
    /// varIndexBase + 1.
    pub yx: Fixed,
    /// x-component of transformed y-basis vector. For variation, use
    /// varIndexBase + 2.
    pub xy: Fixed,
    /// y-component of transformed y-basis vector. For variation, use
    /// varIndexBase + 3.
    pub yy: Fixed,
    /// Translation in x direction. For variation, use varIndexBase + 4.
    pub dx: Fixed,
    /// Translation in y direction. For variation, use varIndexBase + 5.
    pub dy: Fixed,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl VarAffine2x3 {
    /// Construct a new `VarAffine2x3`
    pub fn new(
        xx: Fixed,
        yx: Fixed,
        xy: Fixed,
        yy: Fixed,
        dx: Fixed,
        dy: Fixed,
        var_index_base: u32,
    ) -> Self {
        Self {
            xx,
            yx,
            xy,
            yy,
            dx,
            dy,
            var_index_base,
        }
    }
}

impl FontWrite for VarAffine2x3 {
    fn write_into(&self, writer: &mut TableWriter) {
        self.xx.write_into(writer);
        self.yx.write_into(writer);
        self.xy.write_into(writer);
        self.yy.write_into(writer);
        self.dx.write_into(writer);
        self.dy.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("VarAffine2x3")
    }
}

impl Validate for VarAffine2x3 {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::colr::VarAffine2x3<'a>> for VarAffine2x3 {
    fn from_obj_ref(obj: &read_fonts::tables::colr::VarAffine2x3<'a>, _: FontData) -> Self {
        VarAffine2x3 {
            xx: obj.xx(),
            yx: obj.yx(),
            xy: obj.xy(),
            yy: obj.yy(),
            dx: obj.dx(),
            dy: obj.dy(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::VarAffine2x3<'a>> for VarAffine2x3 {}

impl<'a> FontRead<'a> for VarAffine2x3 {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::VarAffine2x3 as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [PaintTranslate](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-14-and-15-painttranslate-paintvartranslate) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintTranslate {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Translation in x direction.
    pub dx: FWord,
    /// Translation in y direction.
    pub dy: FWord,
}

impl PaintTranslate {
    /// Construct a new `PaintTranslate`
    pub fn new(paint: Paint, dx: FWord, dy: FWord) -> Self {
        Self {
            paint: paint.into(),
            dx,
            dy,
        }
    }
}

impl FontWrite for PaintTranslate {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (14 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.dx.write_into(writer);
        self.dy.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintTranslate")
    }
}

impl Validate for PaintTranslate {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintTranslate", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintTranslate<'a>> for PaintTranslate {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintTranslate<'a>, _: FontData) -> Self {
        PaintTranslate {
            paint: obj.paint().to_owned_table(),
            dx: obj.dx(),
            dy: obj.dy(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintTranslate<'a>> for PaintTranslate {}

impl<'a> FontRead<'a> for PaintTranslate {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintTranslate as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarTranslate](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-14-and-15-painttranslate-paintvartranslate) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarTranslate {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Translation in x direction. For variation, use varIndexBase + 0.
    pub dx: FWord,
    /// Translation in y direction. For variation, use varIndexBase + 1.
    pub dy: FWord,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarTranslate {
    /// Construct a new `PaintVarTranslate`
    pub fn new(paint: Paint, dx: FWord, dy: FWord, var_index_base: u32) -> Self {
        Self {
            paint: paint.into(),
            dx,
            dy,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarTranslate {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (15 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.dx.write_into(writer);
        self.dy.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarTranslate")
    }
}

impl Validate for PaintVarTranslate {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarTranslate", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarTranslate<'a>> for PaintVarTranslate {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintVarTranslate<'a>, _: FontData) -> Self {
        PaintVarTranslate {
            paint: obj.paint().to_owned_table(),
            dx: obj.dx(),
            dy: obj.dy(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarTranslate<'a>> for PaintVarTranslate {}

impl<'a> FontRead<'a> for PaintVarTranslate {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarTranslate as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintScale](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintScale {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Scale factor in x direction.
    pub scale_x: F2Dot14,
    /// Scale factor in y direction.
    pub scale_y: F2Dot14,
}

impl PaintScale {
    /// Construct a new `PaintScale`
    pub fn new(paint: Paint, scale_x: F2Dot14, scale_y: F2Dot14) -> Self {
        Self {
            paint: paint.into(),
            scale_x,
            scale_y,
        }
    }
}

impl FontWrite for PaintScale {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (16 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.scale_x.write_into(writer);
        self.scale_y.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintScale")
    }
}

impl Validate for PaintScale {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintScale", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintScale<'a>> for PaintScale {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintScale<'a>, _: FontData) -> Self {
        PaintScale {
            paint: obj.paint().to_owned_table(),
            scale_x: obj.scale_x(),
            scale_y: obj.scale_y(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintScale<'a>> for PaintScale {}

impl<'a> FontRead<'a> for PaintScale {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintScale as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [PaintVarScale](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarScale {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Scale factor in x direction. For variation, use varIndexBase +
    /// 0.
    pub scale_x: F2Dot14,
    /// Scale factor in y direction. For variation, use varIndexBase +
    /// 1.
    pub scale_y: F2Dot14,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarScale {
    /// Construct a new `PaintVarScale`
    pub fn new(paint: Paint, scale_x: F2Dot14, scale_y: F2Dot14, var_index_base: u32) -> Self {
        Self {
            paint: paint.into(),
            scale_x,
            scale_y,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarScale {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (17 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.scale_x.write_into(writer);
        self.scale_y.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarScale")
    }
}

impl Validate for PaintVarScale {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarScale", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarScale<'a>> for PaintVarScale {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintVarScale<'a>, _: FontData) -> Self {
        PaintVarScale {
            paint: obj.paint().to_owned_table(),
            scale_x: obj.scale_x(),
            scale_y: obj.scale_y(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarScale<'a>> for PaintVarScale {}

impl<'a> FontRead<'a> for PaintVarScale {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarScale as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintScaleAroundCenter](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintScaleAroundCenter {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Scale factor in x direction.
    pub scale_x: F2Dot14,
    /// Scale factor in y direction.
    pub scale_y: F2Dot14,
    /// x coordinate for the center of scaling.
    pub center_x: FWord,
    /// y coordinate for the center of scaling.
    pub center_y: FWord,
}

impl PaintScaleAroundCenter {
    /// Construct a new `PaintScaleAroundCenter`
    pub fn new(
        paint: Paint,
        scale_x: F2Dot14,
        scale_y: F2Dot14,
        center_x: FWord,
        center_y: FWord,
    ) -> Self {
        Self {
            paint: paint.into(),
            scale_x,
            scale_y,
            center_x,
            center_y,
        }
    }
}

impl FontWrite for PaintScaleAroundCenter {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (18 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.scale_x.write_into(writer);
        self.scale_y.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintScaleAroundCenter")
    }
}

impl Validate for PaintScaleAroundCenter {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintScaleAroundCenter", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintScaleAroundCenter<'a>>
    for PaintScaleAroundCenter
{
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintScaleAroundCenter<'a>,
        _: FontData,
    ) -> Self {
        PaintScaleAroundCenter {
            paint: obj.paint().to_owned_table(),
            scale_x: obj.scale_x(),
            scale_y: obj.scale_y(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintScaleAroundCenter<'a>>
    for PaintScaleAroundCenter
{
}

impl<'a> FontRead<'a> for PaintScaleAroundCenter {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintScaleAroundCenter as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarScaleAroundCenter](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarScaleAroundCenter {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Scale factor in x direction. For variation, use varIndexBase +
    /// 0.
    pub scale_x: F2Dot14,
    /// Scale factor in y direction. For variation, use varIndexBase +
    /// 1.
    pub scale_y: F2Dot14,
    /// x coordinate for the center of scaling. For variation, use
    /// varIndexBase + 2.
    pub center_x: FWord,
    /// y coordinate for the center of scaling. For variation, use
    /// varIndexBase + 3.
    pub center_y: FWord,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarScaleAroundCenter {
    /// Construct a new `PaintVarScaleAroundCenter`
    pub fn new(
        paint: Paint,
        scale_x: F2Dot14,
        scale_y: F2Dot14,
        center_x: FWord,
        center_y: FWord,
        var_index_base: u32,
    ) -> Self {
        Self {
            paint: paint.into(),
            scale_x,
            scale_y,
            center_x,
            center_y,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarScaleAroundCenter {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (19 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.scale_x.write_into(writer);
        self.scale_y.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarScaleAroundCenter")
    }
}

impl Validate for PaintVarScaleAroundCenter {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarScaleAroundCenter", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarScaleAroundCenter<'a>>
    for PaintVarScaleAroundCenter
{
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintVarScaleAroundCenter<'a>,
        _: FontData,
    ) -> Self {
        PaintVarScaleAroundCenter {
            paint: obj.paint().to_owned_table(),
            scale_x: obj.scale_x(),
            scale_y: obj.scale_y(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarScaleAroundCenter<'a>>
    for PaintVarScaleAroundCenter
{
}

impl<'a> FontRead<'a> for PaintVarScaleAroundCenter {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarScaleAroundCenter as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintScaleUniform](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintScaleUniform {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Scale factor in x and y directions.
    pub scale: F2Dot14,
}

impl PaintScaleUniform {
    /// Construct a new `PaintScaleUniform`
    pub fn new(paint: Paint, scale: F2Dot14) -> Self {
        Self {
            paint: paint.into(),
            scale,
        }
    }
}

impl FontWrite for PaintScaleUniform {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (20 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.scale.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintScaleUniform")
    }
}

impl Validate for PaintScaleUniform {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintScaleUniform", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintScaleUniform<'a>> for PaintScaleUniform {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintScaleUniform<'a>, _: FontData) -> Self {
        PaintScaleUniform {
            paint: obj.paint().to_owned_table(),
            scale: obj.scale(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintScaleUniform<'a>> for PaintScaleUniform {}

impl<'a> FontRead<'a> for PaintScaleUniform {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintScaleUniform as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarScaleUniform](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarScaleUniform {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Scale factor in x and y directions. For variation, use
    /// varIndexBase + 0.
    pub scale: F2Dot14,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarScaleUniform {
    /// Construct a new `PaintVarScaleUniform`
    pub fn new(paint: Paint, scale: F2Dot14, var_index_base: u32) -> Self {
        Self {
            paint: paint.into(),
            scale,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarScaleUniform {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (21 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.scale.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarScaleUniform")
    }
}

impl Validate for PaintVarScaleUniform {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarScaleUniform", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarScaleUniform<'a>> for PaintVarScaleUniform {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintVarScaleUniform<'a>, _: FontData) -> Self {
        PaintVarScaleUniform {
            paint: obj.paint().to_owned_table(),
            scale: obj.scale(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarScaleUniform<'a>> for PaintVarScaleUniform {}

impl<'a> FontRead<'a> for PaintVarScaleUniform {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarScaleUniform as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintScaleUniformAroundCenter](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintScaleUniformAroundCenter {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Scale factor in x and y directions.
    pub scale: F2Dot14,
    /// x coordinate for the center of scaling.
    pub center_x: FWord,
    /// y coordinate for the center of scaling.
    pub center_y: FWord,
}

impl PaintScaleUniformAroundCenter {
    /// Construct a new `PaintScaleUniformAroundCenter`
    pub fn new(paint: Paint, scale: F2Dot14, center_x: FWord, center_y: FWord) -> Self {
        Self {
            paint: paint.into(),
            scale,
            center_x,
            center_y,
        }
    }
}

impl FontWrite for PaintScaleUniformAroundCenter {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (22 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.scale.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintScaleUniformAroundCenter")
    }
}

impl Validate for PaintScaleUniformAroundCenter {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintScaleUniformAroundCenter", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintScaleUniformAroundCenter<'a>>
    for PaintScaleUniformAroundCenter
{
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintScaleUniformAroundCenter<'a>,
        _: FontData,
    ) -> Self {
        PaintScaleUniformAroundCenter {
            paint: obj.paint().to_owned_table(),
            scale: obj.scale(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintScaleUniformAroundCenter<'a>>
    for PaintScaleUniformAroundCenter
{
}

impl<'a> FontRead<'a> for PaintScaleUniformAroundCenter {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintScaleUniformAroundCenter as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarScaleUniformAroundCenter](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarScaleUniformAroundCenter {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Scale factor in x and y directions. For variation, use
    /// varIndexBase + 0.
    pub scale: F2Dot14,
    /// x coordinate for the center of scaling. For variation, use
    /// varIndexBase + 1.
    pub center_x: FWord,
    /// y coordinate for the center of scaling. For variation, use
    /// varIndexBase + 2.
    pub center_y: FWord,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarScaleUniformAroundCenter {
    /// Construct a new `PaintVarScaleUniformAroundCenter`
    pub fn new(
        paint: Paint,
        scale: F2Dot14,
        center_x: FWord,
        center_y: FWord,
        var_index_base: u32,
    ) -> Self {
        Self {
            paint: paint.into(),
            scale,
            center_x,
            center_y,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarScaleUniformAroundCenter {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (23 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.scale.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarScaleUniformAroundCenter")
    }
}

impl Validate for PaintVarScaleUniformAroundCenter {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarScaleUniformAroundCenter", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarScaleUniformAroundCenter<'a>>
    for PaintVarScaleUniformAroundCenter
{
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintVarScaleUniformAroundCenter<'a>,
        _: FontData,
    ) -> Self {
        PaintVarScaleUniformAroundCenter {
            paint: obj.paint().to_owned_table(),
            scale: obj.scale(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarScaleUniformAroundCenter<'a>>
    for PaintVarScaleUniformAroundCenter
{
}

impl<'a> FontRead<'a> for PaintVarScaleUniformAroundCenter {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarScaleUniformAroundCenter as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintRotate](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-24-to-27-paintrotate-paintvarrotate-paintrotatearoundcenter-paintvarrotatearoundcenter) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintRotate {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Rotation angle, 180° in counter-clockwise degrees per 1.0 of
    /// value.
    pub angle: F2Dot14,
}

impl PaintRotate {
    /// Construct a new `PaintRotate`
    pub fn new(paint: Paint, angle: F2Dot14) -> Self {
        Self {
            paint: paint.into(),
            angle,
        }
    }
}

impl FontWrite for PaintRotate {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (24 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.angle.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintRotate")
    }
}

impl Validate for PaintRotate {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintRotate", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintRotate<'a>> for PaintRotate {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintRotate<'a>, _: FontData) -> Self {
        PaintRotate {
            paint: obj.paint().to_owned_table(),
            angle: obj.angle(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintRotate<'a>> for PaintRotate {}

impl<'a> FontRead<'a> for PaintRotate {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintRotate as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [PaintVarRotate](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-24-to-27-paintrotate-paintvarrotate-paintrotatearoundcenter-paintvarrotatearoundcenter) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarRotate {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Rotation angle, 180° in counter-clockwise degrees per 1.0 of
    /// value. For variation, use varIndexBase + 0.
    pub angle: F2Dot14,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarRotate {
    /// Construct a new `PaintVarRotate`
    pub fn new(paint: Paint, angle: F2Dot14, var_index_base: u32) -> Self {
        Self {
            paint: paint.into(),
            angle,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarRotate {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (25 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.angle.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarRotate")
    }
}

impl Validate for PaintVarRotate {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarRotate", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarRotate<'a>> for PaintVarRotate {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintVarRotate<'a>, _: FontData) -> Self {
        PaintVarRotate {
            paint: obj.paint().to_owned_table(),
            angle: obj.angle(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarRotate<'a>> for PaintVarRotate {}

impl<'a> FontRead<'a> for PaintVarRotate {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarRotate as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintRotateAroundCenter](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-24-to-27-paintrotate-paintvarrotate-paintrotatearoundcenter-paintvarrotatearoundcenter) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintRotateAroundCenter {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Rotation angle, 180° in counter-clockwise degrees per 1.0 of
    /// value.
    pub angle: F2Dot14,
    /// x coordinate for the center of rotation.
    pub center_x: FWord,
    /// y coordinate for the center of rotation.
    pub center_y: FWord,
}

impl PaintRotateAroundCenter {
    /// Construct a new `PaintRotateAroundCenter`
    pub fn new(paint: Paint, angle: F2Dot14, center_x: FWord, center_y: FWord) -> Self {
        Self {
            paint: paint.into(),
            angle,
            center_x,
            center_y,
        }
    }
}

impl FontWrite for PaintRotateAroundCenter {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (26 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.angle.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintRotateAroundCenter")
    }
}

impl Validate for PaintRotateAroundCenter {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintRotateAroundCenter", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintRotateAroundCenter<'a>>
    for PaintRotateAroundCenter
{
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintRotateAroundCenter<'a>,
        _: FontData,
    ) -> Self {
        PaintRotateAroundCenter {
            paint: obj.paint().to_owned_table(),
            angle: obj.angle(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintRotateAroundCenter<'a>>
    for PaintRotateAroundCenter
{
}

impl<'a> FontRead<'a> for PaintRotateAroundCenter {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintRotateAroundCenter as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarRotateAroundCenter](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-24-to-27-paintrotate-paintvarrotate-paintrotatearoundcenter-paintvarrotatearoundcenter) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarRotateAroundCenter {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Rotation angle, 180° in counter-clockwise degrees per 1.0 of
    /// value. For variation, use varIndexBase + 0.
    pub angle: F2Dot14,
    /// x coordinate for the center of rotation. For variation, use
    /// varIndexBase + 1.
    pub center_x: FWord,
    /// y coordinate for the center of rotation. For variation, use
    /// varIndexBase + 2.
    pub center_y: FWord,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarRotateAroundCenter {
    /// Construct a new `PaintVarRotateAroundCenter`
    pub fn new(
        paint: Paint,
        angle: F2Dot14,
        center_x: FWord,
        center_y: FWord,
        var_index_base: u32,
    ) -> Self {
        Self {
            paint: paint.into(),
            angle,
            center_x,
            center_y,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarRotateAroundCenter {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (27 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.angle.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarRotateAroundCenter")
    }
}

impl Validate for PaintVarRotateAroundCenter {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarRotateAroundCenter", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarRotateAroundCenter<'a>>
    for PaintVarRotateAroundCenter
{
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintVarRotateAroundCenter<'a>,
        _: FontData,
    ) -> Self {
        PaintVarRotateAroundCenter {
            paint: obj.paint().to_owned_table(),
            angle: obj.angle(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarRotateAroundCenter<'a>>
    for PaintVarRotateAroundCenter
{
}

impl<'a> FontRead<'a> for PaintVarRotateAroundCenter {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarRotateAroundCenter as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintSkew](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-28-to-31-paintskew-paintvarskew-paintskewaroundcenter-paintvarskewaroundcenter) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintSkew {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Angle of skew in the direction of the x-axis, 180° in
    /// counter-clockwise degrees per 1.0 of value.
    pub x_skew_angle: F2Dot14,
    /// Angle of skew in the direction of the y-axis, 180° in
    /// counter-clockwise degrees per 1.0 of value.
    pub y_skew_angle: F2Dot14,
}

impl PaintSkew {
    /// Construct a new `PaintSkew`
    pub fn new(paint: Paint, x_skew_angle: F2Dot14, y_skew_angle: F2Dot14) -> Self {
        Self {
            paint: paint.into(),
            x_skew_angle,
            y_skew_angle,
        }
    }
}

impl FontWrite for PaintSkew {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (28 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.x_skew_angle.write_into(writer);
        self.y_skew_angle.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintSkew")
    }
}

impl Validate for PaintSkew {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintSkew", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintSkew<'a>> for PaintSkew {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintSkew<'a>, _: FontData) -> Self {
        PaintSkew {
            paint: obj.paint().to_owned_table(),
            x_skew_angle: obj.x_skew_angle(),
            y_skew_angle: obj.y_skew_angle(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintSkew<'a>> for PaintSkew {}

impl<'a> FontRead<'a> for PaintSkew {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintSkew as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [PaintVarSkew](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-28-to-31-paintskew-paintvarskew-paintskewaroundcenter-paintvarskewaroundcenter) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarSkew {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Angle of skew in the direction of the x-axis, 180° ┬░ in
    /// counter-clockwise degrees per 1.0 of value. For variation, use
    /// varIndexBase + 0.
    pub x_skew_angle: F2Dot14,
    /// Angle of skew in the direction of the y-axis, 180° in
    /// counter-clockwise degrees per 1.0 of value. For variation, use
    /// varIndexBase + 1.
    pub y_skew_angle: F2Dot14,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarSkew {
    /// Construct a new `PaintVarSkew`
    pub fn new(
        paint: Paint,
        x_skew_angle: F2Dot14,
        y_skew_angle: F2Dot14,
        var_index_base: u32,
    ) -> Self {
        Self {
            paint: paint.into(),
            x_skew_angle,
            y_skew_angle,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarSkew {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (29 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.x_skew_angle.write_into(writer);
        self.y_skew_angle.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarSkew")
    }
}

impl Validate for PaintVarSkew {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarSkew", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarSkew<'a>> for PaintVarSkew {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintVarSkew<'a>, _: FontData) -> Self {
        PaintVarSkew {
            paint: obj.paint().to_owned_table(),
            x_skew_angle: obj.x_skew_angle(),
            y_skew_angle: obj.y_skew_angle(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarSkew<'a>> for PaintVarSkew {}

impl<'a> FontRead<'a> for PaintVarSkew {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarSkew as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}

/// [PaintSkewAroundCenter](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-28-to-31-paintskew-paintvarskew-paintskewaroundcenter-paintvarskewaroundcenter) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintSkewAroundCenter {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Angle of skew in the direction of the x-axis, 180° in
    /// counter-clockwise degrees per 1.0 of value.
    pub x_skew_angle: F2Dot14,
    /// Angle of skew in the direction of the y-axis, 180° in
    /// counter-clockwise degrees per 1.0 of value.
    pub y_skew_angle: F2Dot14,
    /// x coordinate for the center of rotation.
    pub center_x: FWord,
    /// y coordinate for the center of rotation.
    pub center_y: FWord,
}

impl PaintSkewAroundCenter {
    /// Construct a new `PaintSkewAroundCenter`
    pub fn new(
        paint: Paint,
        x_skew_angle: F2Dot14,
        y_skew_angle: F2Dot14,
        center_x: FWord,
        center_y: FWord,
    ) -> Self {
        Self {
            paint: paint.into(),
            x_skew_angle,
            y_skew_angle,
            center_x,
            center_y,
        }
    }
}

impl FontWrite for PaintSkewAroundCenter {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (30 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.x_skew_angle.write_into(writer);
        self.y_skew_angle.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintSkewAroundCenter")
    }
}

impl Validate for PaintSkewAroundCenter {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintSkewAroundCenter", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintSkewAroundCenter<'a>> for PaintSkewAroundCenter {
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintSkewAroundCenter<'a>,
        _: FontData,
    ) -> Self {
        PaintSkewAroundCenter {
            paint: obj.paint().to_owned_table(),
            x_skew_angle: obj.x_skew_angle(),
            y_skew_angle: obj.y_skew_angle(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintSkewAroundCenter<'a>>
    for PaintSkewAroundCenter
{
}

impl<'a> FontRead<'a> for PaintSkewAroundCenter {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintSkewAroundCenter as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintVarSkewAroundCenter](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#formats-28-to-31-paintskew-paintvarskew-paintskewaroundcenter-paintvarskewaroundcenter) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintVarSkewAroundCenter {
    /// Offset to a Paint subtable.
    pub paint: OffsetMarker<Paint, WIDTH_24>,
    /// Angle of skew in the direction of the x-axis, 180° in
    /// counter-clockwise degrees per 1.0 of value. For variation, use
    /// varIndexBase + 0.
    pub x_skew_angle: F2Dot14,
    /// Angle of skew in the direction of the y-axis, 180° in
    /// counter-clockwise degrees per 1.0 of value. For variation, use
    /// varIndexBase + 1.
    pub y_skew_angle: F2Dot14,
    /// x coordinate for the center of rotation. For variation, use
    /// varIndexBase + 2.
    pub center_x: FWord,
    /// y coordinate for the center of rotation. For variation, use
    /// varIndexBase + 3.
    pub center_y: FWord,
    /// Base index into DeltaSetIndexMap.
    pub var_index_base: u32,
}

impl PaintVarSkewAroundCenter {
    /// Construct a new `PaintVarSkewAroundCenter`
    pub fn new(
        paint: Paint,
        x_skew_angle: F2Dot14,
        y_skew_angle: F2Dot14,
        center_x: FWord,
        center_y: FWord,
        var_index_base: u32,
    ) -> Self {
        Self {
            paint: paint.into(),
            x_skew_angle,
            y_skew_angle,
            center_x,
            center_y,
            var_index_base,
        }
    }
}

impl FontWrite for PaintVarSkewAroundCenter {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (31 as u8).write_into(writer);
        self.paint.write_into(writer);
        self.x_skew_angle.write_into(writer);
        self.y_skew_angle.write_into(writer);
        self.center_x.write_into(writer);
        self.center_y.write_into(writer);
        self.var_index_base.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintVarSkewAroundCenter")
    }
}

impl Validate for PaintVarSkewAroundCenter {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintVarSkewAroundCenter", |ctx| {
            ctx.in_field("paint", |ctx| {
                self.paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintVarSkewAroundCenter<'a>>
    for PaintVarSkewAroundCenter
{
    fn from_obj_ref(
        obj: &read_fonts::tables::colr::PaintVarSkewAroundCenter<'a>,
        _: FontData,
    ) -> Self {
        PaintVarSkewAroundCenter {
            paint: obj.paint().to_owned_table(),
            x_skew_angle: obj.x_skew_angle(),
            y_skew_angle: obj.y_skew_angle(),
            center_x: obj.center_x(),
            center_y: obj.center_y(),
            var_index_base: obj.var_index_base(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintVarSkewAroundCenter<'a>>
    for PaintVarSkewAroundCenter
{
}

impl<'a> FontRead<'a> for PaintVarSkewAroundCenter {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintVarSkewAroundCenter as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

/// [PaintComposite](https://learn.microsoft.com/en-us/typography/opentype/spec/colr#format-32-paintcomposite) table
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PaintComposite {
    /// Offset to a source Paint table.
    pub source_paint: OffsetMarker<Paint, WIDTH_24>,
    /// A CompositeMode enumeration value.
    pub composite_mode: CompositeMode,
    /// Offset to a backdrop Paint table.
    pub backdrop_paint: OffsetMarker<Paint, WIDTH_24>,
}

impl PaintComposite {
    /// Construct a new `PaintComposite`
    pub fn new(source_paint: Paint, composite_mode: CompositeMode, backdrop_paint: Paint) -> Self {
        Self {
            source_paint: source_paint.into(),
            composite_mode,
            backdrop_paint: backdrop_paint.into(),
        }
    }
}

impl FontWrite for PaintComposite {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (32 as u8).write_into(writer);
        self.source_paint.write_into(writer);
        self.composite_mode.write_into(writer);
        self.backdrop_paint.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("PaintComposite")
    }
}

impl Validate for PaintComposite {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("PaintComposite", |ctx| {
            ctx.in_field("source_paint", |ctx| {
                self.source_paint.validate_impl(ctx);
            });
            ctx.in_field("backdrop_paint", |ctx| {
                self.backdrop_paint.validate_impl(ctx);
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::colr::PaintComposite<'a>> for PaintComposite {
    fn from_obj_ref(obj: &read_fonts::tables::colr::PaintComposite<'a>, _: FontData) -> Self {
        PaintComposite {
            source_paint: obj.source_paint().to_owned_table(),
            composite_mode: obj.composite_mode(),
            backdrop_paint: obj.backdrop_paint().to_owned_table(),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::colr::PaintComposite<'a>> for PaintComposite {}

impl<'a> FontRead<'a> for PaintComposite {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::colr::PaintComposite as FontRead>::read(data)
            .map(|x| x.to_owned_table())
    }
}

impl FontWrite for CompositeMode {
    fn write_into(&self, writer: &mut TableWriter) {
        let val = *self as u8;
        writer.write_slice(&val.to_be_bytes())
    }
}
