// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// [Compact Font Format (CFF) version 2](https://learn.microsoft.com/en-us/typography/opentype/spec/cff2) table header
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct Cff2Header {
    /// Header size (bytes).
    pub header_size: u8,
    /// Length of Top DICT structure in bytes.
    pub top_dict_length: u16,
    /// Padding bytes before the start of the Top DICT.
    pub _padding: Vec<u8>,
    /// Data containing the Top DICT.
    pub top_dict_data: Vec<u8>,
    /// Remaining table data.
    pub trailing_data: Vec<u8>,
}

impl Cff2Header {
    /// Construct a new `Cff2Header`
    pub fn new(
        header_size: u8,
        top_dict_length: u16,
        _padding: Vec<u8>,
        top_dict_data: Vec<u8>,
        trailing_data: Vec<u8>,
    ) -> Self {
        Self {
            header_size,
            top_dict_length,
            _padding,
            top_dict_data,
            trailing_data,
        }
    }
}

impl FontWrite for Cff2Header {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (2 as u8).write_into(writer);
        (0 as u8).write_into(writer);
        self.header_size.write_into(writer);
        self.top_dict_length.write_into(writer);
        self._padding.write_into(writer);
        self.top_dict_data.write_into(writer);
        self.trailing_data.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("Cff2Header")
    }
}

impl Validate for Cff2Header {
    fn validate_impl(&self, ctx: &mut ValidationCtx) {
        ctx.in_table("Cff2Header", |ctx| {
            ctx.in_field("top_dict_data", |ctx| {
                if self.top_dict_data.len() > (u16::MAX as usize) {
                    ctx.report("array exceeds max length");
                }
            });
        })
    }
}

impl<'a> FromObjRef<read_fonts::tables::cff2::Cff2Header<'a>> for Cff2Header {
    fn from_obj_ref(obj: &read_fonts::tables::cff2::Cff2Header<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        Cff2Header {
            header_size: obj.header_size(),
            top_dict_length: obj.top_dict_length(),
            _padding: obj._padding().to_owned_obj(offset_data),
            top_dict_data: obj.top_dict_data().to_owned_obj(offset_data),
            trailing_data: obj.trailing_data().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::cff2::Cff2Header<'a>> for Cff2Header {}

impl<'a> FontRead<'a> for Cff2Header {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::cff2::Cff2Header as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}
