// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// [Compact Font Format](https://learn.microsoft.com/en-us/typography/opentype/spec/cff) table header
#[derive(Clone, Debug, Default, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct CffHeader {
    /// Header size (bytes).
    pub hdr_size: u8,
    /// Absolute offset size.
    pub off_size: u8,
    /// Padding bytes before the start of the Name INDEX.
    pub _padding: Vec<u8>,
    /// Remaining table data.
    pub trailing_data: Vec<u8>,
}

impl CffHeader {
    /// Construct a new `CffHeader`
    pub fn new(hdr_size: u8, off_size: u8, _padding: Vec<u8>, trailing_data: Vec<u8>) -> Self {
        Self {
            hdr_size,
            off_size,
            _padding,
            trailing_data,
        }
    }
}

impl FontWrite for CffHeader {
    #[allow(clippy::unnecessary_cast)]
    fn write_into(&self, writer: &mut TableWriter) {
        (1 as u8).write_into(writer);
        (0 as u8).write_into(writer);
        self.hdr_size.write_into(writer);
        self.off_size.write_into(writer);
        self._padding.write_into(writer);
        self.trailing_data.write_into(writer);
    }
    fn table_type(&self) -> TableType {
        TableType::Named("CffHeader")
    }
}

impl Validate for CffHeader {
    fn validate_impl(&self, _ctx: &mut ValidationCtx) {}
}

impl<'a> FromObjRef<read_fonts::tables::cff::CffHeader<'a>> for CffHeader {
    fn from_obj_ref(obj: &read_fonts::tables::cff::CffHeader<'a>, _: FontData) -> Self {
        let offset_data = obj.offset_data();
        CffHeader {
            hdr_size: obj.hdr_size(),
            off_size: obj.off_size(),
            _padding: obj._padding().to_owned_obj(offset_data),
            trailing_data: obj.trailing_data().to_owned_obj(offset_data),
        }
    }
}

#[allow(clippy::needless_lifetimes)]
impl<'a> FromTableRef<read_fonts::tables::cff::CffHeader<'a>> for CffHeader {}

impl<'a> FontRead<'a> for CffHeader {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        <read_fonts::tables::cff::CffHeader as FontRead>::read(data).map(|x| x.to_owned_table())
    }
}
