pub(crate) mod async_container;
#[cfg(feature = "host-port-exposure")]
pub(crate) mod host;
pub(crate) mod request;
#[cfg(feature = "blocking")]
pub(crate) mod sync_container;

pub use async_container::{exec::ExecResult, ContainerAsync};
pub use request::{CgroupnsMode, ContainerRequest, Host, PortMapping};
#[cfg(feature = "blocking")]
#[cfg_attr(docsrs, doc(cfg(feature = "blocking")))]
pub use sync_container::{exec::SyncExecResult, Container};
