// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Table, TableColumn, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let format = Format::new().set_num_format("0.0000");

    let items = ["Foo", "Bar", "Baz", "Bop"];
    let data = [
        [1234, 0, 4321],
        [1256, 0, 4320],
        [2234, 0, 4332],
        [1324, 0, 4333],
    ];

    worksheet.write_column(2, 2, items)?;
    worksheet.write_row_matrix(2, 3, data)?;

    worksheet.set_column_range_width(2, 5, 10.288)?;

    let columns = vec![
        TableColumn::default(),
        TableColumn::default(),
        TableColumn::default(),
        TableColumn::new()
            .set_formula("BASE(0,2)")
            .set_format(format),
    ];

    let table = Table::new().set_columns(&columns);

    worksheet.add_table(1, 2, 5, 5, &table)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_table35() {
    let test_runner = common::TestRunner::new()
        .set_name("table35")
        .set_function(create_new_xlsx_file)
        .ignore_calc_chain()
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
