// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Image, Note, Table, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.set_column_width(2, 10.288)?;
    worksheet.set_column_width(3, 10.288)?;
    worksheet.set_column_width(4, 10.288)?;
    worksheet.set_column_width(5, 10.288)?;

    let table = Table::new();
    worksheet.add_table(2, 2, 12, 5, &table)?;

    worksheet.write_url_with_format(0, 0, "http://perl.com/", &Format::default())?;

    let image = Image::new("tests/input/images/blue.png")?.set_alt_text("blue.png");

    worksheet.insert_image(3, 0, &image)?;

    worksheet.set_default_note_author("John");
    let note = Note::new("Test1").add_author_prefix(false);
    worksheet.insert_note(0, 7, &note)?;

    let note = Note::new("Test2").add_author_prefix(false);
    worksheet.insert_note(0, 9, &note)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_table05() {
    let test_runner = common::TestRunner::new()
        .set_name("table05")
        // We ignore these files since the order of the strings is different
        // from Excel and we are testing for rel file creation and order.
        .ignore_file("xl/sharedStrings.xml")
        .ignore_file("xl/worksheets/sheet1.xml")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
