// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test to demonstrate row or column formatting.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let bold = Format::new().set_bold();
    let default = Format::default();

    worksheet.set_column_width(1, 5)?;
    worksheet.set_column_width(2, 5)?;
    worksheet.set_column_width(3, 5)?;

    worksheet.set_column_width(5, 8)?;
    worksheet.set_column_hidden(5)?;

    // Workaround for dimensions.
    worksheet.set_column_format(5, &bold)?;
    worksheet.set_column_format(5, &default)?;

    worksheet.set_column_format(7, &bold)?;

    worksheet.set_column_width(9, 2)?;

    worksheet.set_column_hidden(11)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_row_col_format13() {
    let test_runner = common::TestRunner::new()
        .set_name("row_col_format13")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
