// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test to demonstrate row or column formatting. This test has an explicit
// format for the row/col intersection.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let bold = Format::new().set_bold();
    let mixed = Format::new().set_bold().set_italic();
    let italic = Format::new().set_italic();

    worksheet.set_row_format(4, &bold)?;
    worksheet.write_string_with_format(4, 2, "Foo", &mixed)?;
    worksheet.set_column_format(2, &italic)?;

    worksheet.write_string(0, 2, "Foo")?;
    worksheet.write_string(4, 0, "Foo")?;

    workbook.save(filename)?;

    Ok(())
}

// Test to demonstrate row or column formatting. This test has an implicit
// format for the row/col intersection.
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let bold = Format::new().set_bold();
    let mixed = Format::new().set_bold().set_italic();
    let italic = Format::new().set_italic();

    // Set the order of the formats.
    workbook.register_format(&bold);
    workbook.register_format(&mixed);

    let worksheet = workbook.add_worksheet();

    worksheet.set_row_format(4, &bold)?;
    worksheet.set_column_format(2, &italic)?;

    worksheet.write_string(0, 2, "Foo")?;
    worksheet.write_string(4, 0, "Foo")?;
    worksheet.write_string(4, 2, "Foo")?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_row_col_format09_1() {
    let test_runner = common::TestRunner::new()
        .set_name("row_col_format09")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_row_col_format09_2() {
    let test_runner = common::TestRunner::new()
        .set_name("row_col_format09")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
