// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test to demonstrate row or column formatting.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let bold = Format::new().set_bold();
    let italic = Format::new().set_italic();

    worksheet.set_column_format(0, &bold)?;
    worksheet.set_column_format(2, &italic)?;

    worksheet.write_string(0, 0, "Foo")?;
    worksheet.write_string(0, 2, "Bar")?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_row_col_format06() {
    let test_runner = common::TestRunner::new()
        .set_name("row_col_format06")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
