// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Color, Format, Workbook, XlsxError};

// Test to demonstrate rich strings.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    let red = Format::new().set_font_color(Color::Red);
    let default = Format::default();

    worksheet.write_string_with_format(0, 0, "Foo", &red)?;
    worksheet.write_string(1, 0, "Bar")?;

    let segments = [(&default, "ab"), (&red, "cde"), (&default, "fg")];
    worksheet.write_rich_string(2, 0, &segments)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_rich_string06() {
    let test_runner = common::TestRunner::new()
        .set_name("rich_string06")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
