// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Chart, ChartType, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet().set_name("Sheet 1")?;

    worksheet.write_column(0, 0, [1, 2, 3, 4, 5])?;
    worksheet.write_column(0, 1, [2, 4, 6, 8, 10])?;
    worksheet.write_column(0, 2, [3, 6, 9, 12, 15])?;

    let mut chart = Chart::new(ChartType::Pie);
    chart
        .add_series()
        .set_values(("Sheet 1", 0, 0, 4, 0))
        .set_name(("Sheet 1", 0, 0));

    chart.title().set_name("Foo");

    worksheet.insert_chart(8, 4, &chart)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_quote_name04() {
    let test_runner = common::TestRunner::new()
        .set_name("quote_name04")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
