// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Chart, ChartType, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    // Test quoted/non-quoted sheet names.
    let sheetnames = [
        "Sheet<1", "Sheet>2", "Sheet=3", "Sheet@4", "Sheet^5", "Sheet`6", "Sheet_7", "Sheet~8",
    ];

    for sheetname in sheetnames {
        let worksheet = workbook.add_worksheet().set_name(sheetname)?;

        worksheet.write_column(0, 0, [1, 2, 3, 4, 5])?;
        worksheet.write_column(0, 1, [2, 4, 6, 8, 10])?;
        worksheet.write_column(0, 2, [3, 6, 9, 12, 15])?;

        let mut chart = Chart::new(ChartType::Pie);
        chart.add_series().set_values((sheetname, 0, 0, 4, 0));

        worksheet.insert_chart_with_offset(5, 4, &chart, 26, 17)?;
    }

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_quote_name03() {
    let test_runner = common::TestRunner::new()
        .set_name("quote_name03")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
