// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{ProtectionOptions, Workbook, XlsxError};

// Test to demonstrate worksheet protection.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    let options = ProtectionOptions {
        select_locked_cells: false,
        select_unlocked_cells: false,
        format_cells: true,
        format_columns: true,
        format_rows: true,
        insert_columns: true,
        insert_rows: true,
        insert_links: true,

        delete_columns: true,
        delete_rows: true,
        sort: true,
        use_autofilter: true,
        use_pivot_tables: true,
        edit_scenarios: true,
        edit_objects: true,
        contents: true,
    };

    worksheet.protect_with_options(&options);

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_protect08() {
    let test_runner = common::TestRunner::new()
        .set_name("protect08")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
