// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, FormatBorder, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let cell_format = Format::new()
        .set_background_color("#FFFF00")
        .set_border(FormatBorder::Thin)
        .set_border_color("#FF0000");

    // Set the format for a range.
    for col_num in 0..16_384 {
        worksheet.set_column_format(col_num, &cell_format)?;
    }

    workbook.save(filename)?;

    Ok(())
}

// With the range version.
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let cell_format = Format::new()
        .set_background_color("#FFFF00")
        .set_border(FormatBorder::Thin)
        .set_border_color("#FF0000");

    // Set the format for a range.
    worksheet.set_column_range_format(0, 16_383, &cell_format)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_overlay07_1() {
    let test_runner = common::TestRunner::new()
        .set_name("overlay07")
        .unique("1")
        .set_function(create_new_xlsx_file_1)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_overlay07_2() {
    let test_runner = common::TestRunner::new()
        .set_name("overlay07")
        .unique("2")
        .set_function(create_new_xlsx_file_2)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
