// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Table, TableColumn, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet_with_low_memory();
    let format = Format::new().set_num_format("0.0000");

    worksheet.set_column_range_width(2, 5, 10.288)?;

    let columns = vec![
        TableColumn::default(),
        TableColumn::default(),
        TableColumn::default(),
        TableColumn::new()
            .set_formula("BASE(0,2)")
            .set_format(format),
    ];

    let table = Table::new().set_columns(&columns);

    worksheet.add_table(1, 2, 5, 5, &table)?;

    worksheet.write(2, 2, "Foo")?;
    worksheet.write_row(2, 3, [1234, 0])?;

    worksheet.write(3, 2, "Bar")?;
    worksheet.write_row(3, 3, [1256, 0])?;

    worksheet.write(4, 2, "Baz")?;
    worksheet.write_row(4, 3, [2234, 0])?;

    worksheet.write(5, 2, "Bop")?;
    worksheet.write_row(5, 3, [1324, 0])?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_optimize_table35() {
    let test_runner = common::TestRunner::new()
        .set_name("table35")
        .set_function(create_new_xlsx_file)
        .ignore_calc_chain()
        .unique("optimize")
        .ignore_worksheet_spans()
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
