// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Table, TableColumn, TableFunction, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    // Pre-populate the string table to get the same order as Excel.
    workbook.populate_string_table("Column1", 0);
    workbook.populate_string_table("Column2", 1);
    workbook.populate_string_table("Column3", 2);
    workbook.populate_string_table("Column4", 3);

    let worksheet = workbook.add_worksheet_with_low_memory();

    worksheet.set_column_width(2, 10.288)?;
    worksheet.set_column_width(3, 10.288)?;
    worksheet.set_column_width(4, 10.288)?;
    worksheet.set_column_width(5, 10.288)?;

    let columns = vec![
        TableColumn::new().set_total_label("Total"),
        TableColumn::default(),
        TableColumn::default(),
        TableColumn::new().set_total_function(TableFunction::Count),
    ];

    let table = Table::new().set_columns(&columns).set_total_row(true);

    worksheet.add_table(2, 2, 13, 5, &table)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_optimize_table08() {
    let test_runner = common::TestRunner::new()
        .set_name("table08")
        .set_function(create_new_xlsx_file)
        .ignore_calc_chain()
        .unique("optimize")
        .ignore_worksheet_spans()
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
