// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Table, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet_with_low_memory();

    worksheet.set_paper_size(9);

    worksheet.write_row(1, 1, ["Foo", "Bar", "Baz"])?;

    let table = Table::new();
    worksheet.add_table(1, 1, 4, 3, &table)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_optimize34() {
    let test_runner = common::TestRunner::new()
        .set_name("optimize34")
        .set_function(create_new_xlsx_file)
        .ignore_elements("xl/sharedStrings.xml", "count")
        .ignore_worksheet_spans()
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
