// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet_with_low_memory();

    worksheet.write_string(0, 0, "Apple")?;
    worksheet.write_string(1, 0, "Pear")?;
    worksheet.write_string(2, 0, "Orange")?;
    worksheet.write_string(3, 0, "Pear")?;
    worksheet.write_string(4, 0, "Apple")?;

    let worksheet = workbook.add_worksheet();

    worksheet.write_string(0, 0, "Apple")?;
    worksheet.write_string(1, 0, "Pear")?;
    worksheet.write_string(2, 0, "Orange")?;
    worksheet.write_string(3, 0, "Pear")?;
    worksheet.write_string(4, 0, "Apple")?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_optimize32() {
    let test_runner = common::TestRunner::new()
        .set_name("optimize32")
        .set_function(create_new_xlsx_file)
        .ignore_worksheet_spans()
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
