// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Image, Workbook, XlsxError};

// Test to demonstrate adding images to worksheets.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet1 = workbook.add_worksheet();

    let image = Image::new("tests/input/images/blue.png")?.set_alt_text("blue.png");
    worksheet1.insert_image(0, 0, &image)?;

    let image_red_jpg = Image::new("tests/input/images/red.jpg")?.set_alt_text("red.jpg");
    worksheet1.insert_image(2, 1, &image_red_jpg)?;

    let image_yellow_jpg = Image::new("tests/input/images/yellow.jpg")?.set_alt_text("yellow.jpg");
    worksheet1.insert_image(4, 3, &image_yellow_jpg)?;

    let image_grey_png = Image::new("tests/input/images/grey.png")?.set_alt_text("grey.png");
    worksheet1.insert_image(8, 5, &image_grey_png)?;

    let worksheet2 = workbook.add_worksheet();

    let image_blue_png = Image::new("tests/input/images/blue.png")?.set_alt_text("blue.png");
    worksheet2.insert_image(0, 0, &image_blue_png)?;

    let image_red_jpg = Image::new("tests/input/images/red.jpg")?.set_alt_text("red.jpg");
    worksheet2.insert_image(2, 1, &image_red_jpg)?;

    let image_yellow_jpg = Image::new("tests/input/images/yellow.jpg")?.set_alt_text("yellow.jpg");
    worksheet2.insert_image(4, 3, &image_yellow_jpg)?;

    let image_greg_png = Image::new("tests/input/images/grey.png")?.set_alt_text("grey.png");
    worksheet2.insert_image(8, 5, &image_greg_png)?;

    let worksheet3 = workbook.add_worksheet();

    let image_blue_png = Image::new("tests/input/images/blue.png")?.set_alt_text("blue.png");
    worksheet3.insert_image(0, 0, &image_blue_png)?;

    let image_red_jpg = Image::new("tests/input/images/red.jpg")?.set_alt_text("red.jpg");
    worksheet3.insert_image(2, 1, &image_red_jpg)?;

    let image_yellow_jpg = Image::new("tests/input/images/yellow.jpg")?.set_alt_text("yellow.jpg");
    worksheet3.insert_image(4, 3, &image_yellow_jpg)?;

    let image_grey_png = Image::new("tests/input/images/grey.png")?.set_alt_text("grey.png");
    worksheet3.insert_image(8, 5, &image_grey_png)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_image49() {
    let test_runner = common::TestRunner::new()
        .set_name("image49")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
