// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Image, Workbook, XlsxError};

// Test to demonstrate adding images to worksheets.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    let image = Image::new("tests/input/images/grey.png")?
        .set_alt_text("grey.png")
        .set_scale_width(0.5)
        .set_scale_height(0.5);

    worksheet.insert_image(2, 1, &image)?;

    workbook.save(filename)?;

    Ok(())
}

// Test to demonstrate adding images to worksheets.
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    let image = Image::new("tests/input/images/grey.png")?
        .set_alt_text("grey.png")
        .set_scale_to_size(99.0 / 2.0, 69.0 / 2.0, false);

    worksheet.insert_image(2, 1, &image)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_image08_1() {
    let test_runner = common::TestRunner::new()
        .set_name("image08")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_image08_2() {
    let test_runner = common::TestRunner::new()
        .set_name("image08")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
