// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{IgnoreError, Workbook, XlsxError};

// Create rust_xlsxwriter file to compare against Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    worksheet.write_string(0, 0, "123")?;
    worksheet
        .write_formula(1, 0, "=1/0")?
        .set_formula_result(1, 0, "#DIV/0!");

    worksheet.ignore_error(0, 0, IgnoreError::NumberStoredAsText)?;
    worksheet.ignore_error(1, 0, IgnoreError::FormulaError)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_ignore_error05() {
    let test_runner = common::TestRunner::new()
        .set_name("ignore_error05")
        .ignore_calc_chain()
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
