// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Chart, ChartType, Image, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    worksheet.write(0, 0, 1)?;
    worksheet.write(1, 0, 2)?;

    let mut chart = Chart::new(ChartType::Pie);
    chart.add_series().set_values(("Sheet1", 0, 0, 1, 0));

    worksheet.insert_chart(11, 4, &chart)?;

    let image = Image::new("tests/input/images/red.png")?
        .set_alt_text("red.png")
        .set_url("https://github.com/jmcnamara")?;

    worksheet.insert_image(8, 4, &image)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_hyperlink36() {
    let test_runner = common::TestRunner::new()
        .set_name("hyperlink36")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
