// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test to demonstrate simple hyperlinks.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet1 = workbook.add_worksheet();
    let format = Format::default();

    worksheet1.write_url_with_options(0, 0, "internal:Sheet2!A1", "", "", Some(&format))?;
    worksheet1.write_url_with_options(2, 0, "internal:Sheet2!A1:A5", "", "", Some(&format))?;
    worksheet1.write_url_with_options(
        4,
        0,
        "internal:'Data Sheet'!D5",
        "Some text",
        "",
        Some(&format),
    )?;
    worksheet1.write_url_with_options(11, 4, "internal:Sheet1!J1", "", "", Some(&format))?;
    worksheet1.write_url_with_options(
        16,
        6,
        "internal:Sheet2!A1",
        "Some text",
        "",
        Some(&format),
    )?;
    worksheet1.write_url_with_options(
        17,
        0,
        "internal:Sheet2!A1",
        "",
        "Tool Tip 1",
        Some(&format),
    )?;
    worksheet1.write_url_with_options(
        19,
        0,
        "internal:Sheet2!A1",
        "More text",
        "Tool Tip 2",
        Some(&format),
    )?;

    let _worksheet2 = workbook.add_worksheet();
    let _worksheet3 = workbook.add_worksheet().set_name("Data Sheet");

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_hyperlink04() {
    let test_runner = common::TestRunner::new()
        .set_name("hyperlink04")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
