// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Url, Workbook, XlsxError};

// Test to demonstrate simple hyperlinks.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let format = Format::default();

    worksheet.write_url_with_options(0, 0, "http://www.perl.org/", "", "", Some(&format))?;

    workbook.save(filename)?;

    Ok(())
}

// Test with Url struct and generics.
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let format = Format::default();

    worksheet.write_with_format(0, 0, Url::new("http://www.perl.org/"), &format)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_hyperlink01_1() {
    let test_runner = common::TestRunner::new()
        .set_name("hyperlink01")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_hyperlink01_2() {
    let test_runner = common::TestRunner::new()
        .set_name("hyperlink01")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
