// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{HeaderImagePosition, Image, Workbook, XlsxError};

// Test to demonstrate adding header/footer images to worksheets.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    let image1 = Image::new("tests/input/images/red.png")?.set_alt_text("red.png");

    worksheet.insert_image(8, 4, &image1)?;

    let image2 = Image::new("tests/input/images/red.jpg")?;
    let image3 = Image::new("tests/input/images/blue.jpg")?;

    worksheet.set_header("&L&[Picture]&C&G&R&[Picture]");
    worksheet.set_header_image(&image2, HeaderImagePosition::Left)?;
    worksheet.set_header_image(&image3, HeaderImagePosition::Center)?;
    worksheet.set_header_image(&image2, HeaderImagePosition::Right)?;

    worksheet.set_footer("&L&G&C&G&R&G");
    worksheet.set_footer_image(&image3, HeaderImagePosition::Left)?;
    worksheet.set_footer_image(&image2, HeaderImagePosition::Center)?;
    worksheet.set_footer_image(&image3, HeaderImagePosition::Right)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_header_image18() {
    let test_runner = common::TestRunner::new()
        .set_name("header_image18")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
