// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{HeaderImagePosition, Image, Workbook, XlsxError};

// Test to demonstrate adding header/footer images to worksheets.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let image1 = Image::new("tests/input/images/red.jpg")?;
    let image2 = Image::new("tests/input/images/blue.jpg")?;

    let worksheet1 = workbook.add_worksheet();
    worksheet1.set_header("&L&G");
    worksheet1.set_header_image(&image1, HeaderImagePosition::Left)?;

    let worksheet2 = workbook.add_worksheet();
    worksheet2.set_header("&L&G");
    worksheet2.set_header_image(&image2, HeaderImagePosition::Left)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_header_image06() {
    let test_runner = common::TestRunner::new()
        .set_name("header_image06")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
