// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Create rust_xlsxwriter file to compare against Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();

    worksheet
        .write_formula(0, 0, "1+1")?
        .set_formula_result(0, 0, "2");

    worksheet
        .write_formula(1, 0, "\"Foo\"")?
        .set_formula_result(1, 0, "Foo");

    worksheet
        .write_formula(2, 0, "IF(B3,FALSE,TRUE)")?
        .set_formula_result(2, 0, "TRUE");

    worksheet
        .write_formula(3, 0, "IF(B4,TRUE,FALSE)")?
        .set_formula_result(3, 0, "FALSE");

    worksheet
        .write_formula(4, 0, "#DIV/0!")?
        .set_formula_result(4, 0, "#DIV/0!");

    worksheet
        .write_formula(5, 0, "#N/A")?
        .set_formula_result(5, 0, "#N/A");

    worksheet
        .write_formula(6, 0, "#NAME?")?
        .set_formula_result(6, 0, "#NAME?");

    worksheet
        .write_formula(7, 0, "#NULL!")?
        .set_formula_result(7, 0, "#NULL!");

    worksheet
        .write_formula(8, 0, "#NUM!")?
        .set_formula_result(8, 0, "#NUM!");

    worksheet
        .write_formula(9, 0, "#REF!")?
        .set_formula_result(9, 0, "#REF!");

    worksheet
        .write_formula(10, 0, "#VALUE!")?
        .set_formula_result(10, 0, "#VALUE!");

    worksheet
        .write_formula(11, 0, "1/0")?
        .set_formula_result(11, 0, "#DIV/0!");

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_formula_results01() {
    let test_runner = common::TestRunner::new()
        .set_name("formula_results01")
        .set_function(create_new_xlsx_file)
        .ignore_calc_chain()
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
