// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, FormatAlign, Workbook, XlsxError};

// Test case to test simple formatting.

fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();
    let center = Format::new().set_align(FormatAlign::CenterAcross);

    worksheet.write_string_with_format(0, 0, "foo", &center)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_format14() {
    let test_runner = common::TestRunner::new()
        .set_name("format14")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
