// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test case to demonstrate cell font charset formatting. This is a special case
// test for an Arabic font that requires the charset to be enabled/set for it to
// render properly.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let format1 = Format::new()
        .set_font_name("B Nazanin")
        .set_font_family(0)
        .set_font_charset(178);

    let worksheet = workbook.add_worksheet();
    worksheet.write_string_with_format(0, 0, "Foo", &format1)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn format13_font_charset() {
    let test_runner = common::TestRunner::new()
        .set_name("format13")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
