// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test case to test simple formatting.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet1 = workbook.add_worksheet();

    worksheet1.write_string(0, 0, "Foo")?;
    worksheet1.write_number(1, 0, 123)?;

    let _worksheet2 = workbook.add_worksheet().set_name("Data Sheet");
    let worksheet3 = workbook.add_worksheet();

    let bold = Format::new().set_bold();

    worksheet3.write_string(1, 1, "Foo")?;
    worksheet3.write_string_with_format(2, 1, "Bar", &bold)?;
    worksheet3.write_number(3, 2, 234)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_format01() {
    let test_runner = common::TestRunner::new()
        .set_name("format01")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
