// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Chart, ChartType, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.write(0, 0, "Data\x1b[32m1")?;
    worksheet.write(1, 0, "Data\x1b[32m2")?;
    worksheet.write(2, 0, "Data\x1b[32m3")?;
    worksheet.write(3, 0, "Data\x1b[32m4")?;

    worksheet.write(0, 1, 10)?;
    worksheet.write(1, 1, 20)?;
    worksheet.write(2, 1, 10)?;
    worksheet.write(3, 1, 30)?;

    let mut chart = Chart::new(ChartType::Line);
    chart.set_axis_ids(52721920, 53133312);
    chart
        .add_series()
        .set_categories(("Sheet1", 0, 0, 3, 0))
        .set_values(("Sheet1", 0, 1, 3, 1));

    worksheet.insert_chart(8, 4, &chart)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_escapes09() {
    let test_runner = common::TestRunner::new()
        .set_name("escapes09")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
