// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test to demonstrate simple hyperlinks with escapes.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet1 = workbook.add_worksheet().set_name("Start")?;
    let format = Format::default();

    worksheet1.write_url_with_options(
        0,
        0,
        "internal:'A & B'!A1",
        "Jump to A & B",
        "",
        Some(&format),
    )?;

    let _worksheet2 = workbook.add_worksheet().set_name("A & B")?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_escapes05() {
    let test_runner = common::TestRunner::new()
        .set_name("escapes05")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
