// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Formula, Workbook, XlsxError};

// Test strings that need XML escaping.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet().set_name("5&4")?;

    worksheet
        .write_formula(0, 0, r#"=IF(1>2,0,1)"#)?
        .set_formula_result(0, 0, "1");
    worksheet
        .write_formula(1, 0, r#"=CONCATENATE("'","<>&")"#)?
        .set_formula_result(1, 0, "'<>&");
    worksheet
        .write_formula(2, 0, r#"=1&"b""#)?
        .set_formula_result(2, 0, "1b");
    worksheet
        .write_formula(3, 0, r#"="'""#)?
        .set_formula_result(3, 0, r#"'"#);
    worksheet
        .write_formula(4, 0, r#"="""""#)?
        .set_formula_result(4, 0, r#"""#);
    worksheet
        .write_formula(5, 0, r#"="&" & "&""#)?
        .set_formula_result(5, 0, "&&");

    worksheet.write_string(7, 0, r#""&<>"#)?;

    workbook.save(filename)?;

    Ok(())
}

// Test strings that need XML escaping, with Formula struct.
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet().set_name("5&4")?;

    worksheet.write_formula(0, 0, Formula::new(r#"=IF(1>2,0,1)"#).set_result("1"))?;
    worksheet.write_formula(
        1,
        0,
        Formula::new(r#"=CONCATENATE("'","<>&")"#).set_result("'<>&"),
    )?;
    worksheet.write_formula(2, 0, Formula::new(r#"=1&"b""#).set_result("1b"))?;
    worksheet.write_formula(3, 0, Formula::new(r#"="'""#).set_result(r#"'"#))?;
    worksheet.write_formula(4, 0, Formula::new(r#"="""""#).set_result(r#"""#))?;
    worksheet.write_formula(5, 0, Formula::new(r#"="&" & "&""#).set_result("&&"))?;

    worksheet.write_string(7, 0, r#""&<>"#)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_escapes01() {
    let test_runner = common::TestRunner::new()
        .set_name("escapes01")
        .set_function(create_new_xlsx_file_1)
        .ignore_calc_chain()
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn test_escapes01_with_formula_struct() {
    let test_runner = common::TestRunner::new()
        .set_name("escapes01")
        .set_function(create_new_xlsx_file_2)
        .ignore_calc_chain()
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
