// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2023, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Image, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let red = Image::new("tests/input/images/red.png")?;
    let blue = Image::new("tests/input/images/blue.png")?;
    let yellow = Image::new("tests/input/images/yellow.png")?;

    let worksheet1 = workbook.add_worksheet();
    worksheet1.embed_image(0, 0, &red)?;
    worksheet1.embed_image(2, 0, &blue)?;
    worksheet1.embed_image(4, 0, &yellow)?;

    let worksheet2 = workbook.add_worksheet();
    worksheet2.embed_image(0, 0, &yellow)?;
    worksheet2.embed_image(2, 0, &red)?;
    worksheet2.embed_image(4, 0, &blue)?;

    let worksheet3 = workbook.add_worksheet();
    worksheet3.embed_image(0, 0, &blue)?;
    worksheet3.embed_image(2, 0, &yellow)?;
    worksheet3.embed_image(4, 0, &red)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_embed_image13() {
    let test_runner = common::TestRunner::new()
        .set_name("embed_image13")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
