// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2023, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Format, Image, Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    let format = Format::new().set_background_color("#FFFF00");

    let image = Image::new("tests/input/images/red.png")?;
    worksheet.embed_image_with_format(0, 0, &image, &format)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_embed_image12() {
    let test_runner = common::TestRunner::new()
        .set_name("embed_image12")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
