// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Test to demonstrate defined names.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet1 = workbook.add_worksheet();

    worksheet1.write_string(0, 5, "Filter")?;
    worksheet1.write_string(0, 6, "Auto")?;

    worksheet1.autofilter(0, 5, 0, 6)?;
    worksheet1.set_print_area(0, 0, 5, 4)?;
    worksheet1.set_print_fit_to_pages(2, 2);

    let worksheet2 = workbook.add_worksheet();
    worksheet2.set_portrait();

    let worksheet3 = workbook.add_worksheet().set_name("Sheet 3")?;
    worksheet3.set_portrait();

    workbook.define_name("'Sheet 3'!Bar", "='Sheet 3'!$A$1")?;
    workbook.define_name("Abc", "=Sheet1!$A$1")?;
    workbook.define_name("Baz", "=0.98")?;
    workbook.define_name("Sheet2!Bar", "=Sheet2!$A$1")?;
    workbook.define_name("Sheet1!Bar", "=Sheet1!$A$1")?;
    workbook.define_name("Sheet2!aaa", "=Sheet2!$A$1")?;
    workbook.define_name("_Egg", "=Sheet1!$A$1")?;
    workbook.define_name("_Fog", "=Sheet1!$A$1")?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_defined_name01() {
    let test_runner = common::TestRunner::new()
        .set_name("defined_name01")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
