// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{Workbook, XlsxError};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.set_default_row_height(24);
    worksheet.hide_unused_rows(true);
    worksheet.write(0, 0, "Foo")?;
    worksheet.write(9, 0, "Bar")?;
    worksheet.write(19, 0, "Baz")?;

    for row in 1..9 {
        worksheet.set_row_height(row, 24)?;
    }

    for row in 10..20 {
        worksheet.set_row_height(row, 24)?;
    }

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_default_row05() {
    let test_runner = common::TestRunner::new()
        .set_name("default_row05")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
