// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

#[cfg(feature = "rust_decimal")]
use rust_decimal::Decimal;

use crate::common;
use rust_xlsxwriter::{Format, Workbook, XlsxError};

// Test case to demonstrate creating a basic file with some numeric cell data.
fn create_new_xlsx_file_1(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();
    let format = Format::new().set_num_format("\\$0.00");

    worksheet.write(0, 0, 2.1)?;
    worksheet.write_with_format(1, 0, 2.1, &format)?;

    workbook.save(filename)?;

    Ok(())
}

// Write numbers with rust_decimal.
#[cfg(feature = "rust_decimal")]
fn create_new_xlsx_file_2(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();
    let worksheet = workbook.add_worksheet();
    let format = Format::new().set_num_format("\\$0.00");

    let decimal = Decimal::new(210, 2);

    worksheet.write(0, 0, decimal)?;
    worksheet.write_with_format(1, 0, decimal, &format)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn decimal01_1() {
    let test_runner = common::TestRunner::new()
        .set_name("decimal01")
        .set_function(create_new_xlsx_file_1)
        .unique("1")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}

#[test]
fn decimal01_2() {
    let test_runner = common::TestRunner::new()
        .set_name("decimal01")
        .set_function(create_new_xlsx_file_2)
        .unique("2")
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
