// Test case that compares a file generated by rust_xlsxwriter with a file
// created by Excel.
//
// SPDX-License-Identifier: MIT OR Apache-2.0
//
// Copyright 2022-2025, John McNamara, jmcnamara@cpan.org

use crate::common;
use rust_xlsxwriter::{
    ConditionalFormatCustomIcon, ConditionalFormatIconSet, ConditionalFormatIconType,
    ConditionalFormatType, Formula, Workbook, XlsxError,
};

// Create a rust_xlsxwriter file to compare against an Excel file.
fn create_new_xlsx_file(filename: &str) -> Result<(), XlsxError> {
    let mut workbook = Workbook::new();

    let worksheet = workbook.add_worksheet();

    worksheet.write(0, 0, 1)?;
    worksheet.write(1, 0, 2)?;
    worksheet.write(2, 0, 3)?;
    worksheet.write(3, 0, 4)?;
    worksheet.write(4, 0, 5)?;
    worksheet.write(5, 0, 6)?;
    worksheet.write(6, 0, 7)?;
    worksheet.write(7, 0, 8)?;
    worksheet.write(8, 0, 9)?;
    worksheet.write(11, 0, 75)?;

    let conditional_format = ConditionalFormatIconSet::new()
        .set_icon_type(ConditionalFormatIconType::ThreeArrows)
        .reverse_icons(true);

    worksheet.add_conditional_format(0, 0, 0, 0, &conditional_format)?;

    let conditional_format = ConditionalFormatIconSet::new()
        .set_icon_type(ConditionalFormatIconType::ThreeFlags)
        .show_icons_only(true);

    worksheet.add_conditional_format(1, 0, 1, 0, &conditional_format)?;

    let conditional_format = ConditionalFormatIconSet::new()
        .set_icon_type(ConditionalFormatIconType::ThreeTrafficLightsWithRim)
        .reverse_icons(true)
        .show_icons_only(true);

    worksheet.add_conditional_format(2, 0, 2, 0, &conditional_format)?;

    let icons = [
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 0),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 20),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 80),
    ];
    let conditional_format = ConditionalFormatIconSet::new()
        .set_icon_type(ConditionalFormatIconType::ThreeSymbolsCircled)
        .set_icons(&icons);

    worksheet.add_conditional_format(3, 0, 3, 0, &conditional_format)?;

    let icons = [
        ConditionalFormatCustomIcon::new()
            .set_rule(ConditionalFormatType::Percentile, 99)
            .set_greater_than(true), // Should be overridden by default.
        ConditionalFormatCustomIcon::new()
            .set_rule(ConditionalFormatType::Percent, 25)
            .set_greater_than(true),
        ConditionalFormatCustomIcon::new()
            .set_rule(ConditionalFormatType::Percent, 50)
            .set_greater_than(true),
        ConditionalFormatCustomIcon::new()
            .set_rule(ConditionalFormatType::Percent, 75)
            .set_greater_than(true),
    ];
    let conditional_format = ConditionalFormatIconSet::new()
        .set_icon_type(ConditionalFormatIconType::FourArrows)
        .set_icons(&icons);
    worksheet.add_conditional_format(4, 0, 4, 0, &conditional_format)?;

    let icons = [
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 0),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 25),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percentile, 50),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Number, 90),
    ];
    let conditional_format = ConditionalFormatIconSet::new()
        .set_icon_type(ConditionalFormatIconType::FourRedToBlack)
        .set_icons(&icons);
    worksheet.add_conditional_format(5, 0, 5, 0, &conditional_format)?;

    let icons = [
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 0),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 25),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 50),
        ConditionalFormatCustomIcon::new()
            .set_rule(ConditionalFormatType::Percent, Formula::new("$A$12")),
    ];
    let conditional_format = ConditionalFormatIconSet::new()
        .set_icon_type(ConditionalFormatIconType::FourTrafficLights)
        .set_icons(&icons);
    worksheet.add_conditional_format(6, 0, 6, 0, &conditional_format)?;

    let icons = [
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 0),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 20),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 40),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 60),
        ConditionalFormatCustomIcon::new()
            .set_rule(ConditionalFormatType::Formula, Formula::new("$A$12")),
    ];
    let conditional_format = ConditionalFormatIconSet::new()
        .set_icon_type(ConditionalFormatIconType::FiveArrowsGray)
        .set_icons(&icons);
    worksheet.add_conditional_format(7, 0, 7, 0, &conditional_format)?;

    let icons = [
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 0),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 10),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 30),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 50),
        ConditionalFormatCustomIcon::new().set_rule(ConditionalFormatType::Percent, 70),
    ];
    let conditional_format = ConditionalFormatIconSet::new()
        .set_icon_type(ConditionalFormatIconType::FiveQuadrants)
        .reverse_icons(true)
        .set_icons(&icons);
    worksheet.add_conditional_format(8, 0, 8, 0, &conditional_format)?;

    workbook.save(filename)?;

    Ok(())
}

#[test]
fn test_cond_format18() {
    let test_runner = common::TestRunner::new()
        .set_name("cond_format18")
        .set_function(create_new_xlsx_file)
        .initialize();

    test_runner.assert_eq();
    test_runner.cleanup();
}
